/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.referencedoc;

import java.net.URL;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.referencedoc.ObjectReferenceTableModel;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportGenerator;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DefaultDataSourceFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects.DefaultClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateClassFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class ObjectReferenceGenerator {
    private static final String REFERENCE_REPORT = "ObjectReferenceReport.xml";

    private ObjectReferenceGenerator() {
    }

    public static TableModel createData() {
        ClassFactoryCollector cc = new ClassFactoryCollector();
        cc.addFactory(new DefaultClassFactory());
        cc.addFactory(new DefaultDataSourceFactory());
        cc.addFactory(new TemplateClassFactory());
        return new ObjectReferenceTableModel(cc);
    }

    public static void main(String[] args) {
        MasterReport report;
        ClassicEngineBoot.getInstance().start();
        ReportGenerator gen = ReportGenerator.getInstance();
        URL reportURL = ObjectUtilities.getResourceRelative((String)REFERENCE_REPORT, ObjectReferenceGenerator.class);
        if (reportURL == null) {
            System.err.println("The report was not found in the classpath");
            System.err.println("File: ObjectReferenceReport.xml");
            System.exit(1);
            return;
        }
        try {
            report = gen.parseReport(reportURL);
        }
        catch (Exception e) {
            System.err.println("The report could not be parsed.");
            System.err.println("File: ObjectReferenceReport.xml");
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        report.setDataFactory(new TableDataFactory("default", ObjectReferenceGenerator.createData()));
        try {
            HtmlReportUtil.createStreamHTML(report, System.getProperty("user.home") + "/object-reference.html");
            PdfReportUtil.createPDF(report, System.getProperty("user.home") + "/object-reference.pdf");
        }
        catch (Exception e) {
            System.err.println("The report processing failed.");
            System.err.println("File: ObjectReferenceReport.xml");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

