/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.html;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.FastExportTemplate;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentProducerTemplate;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastSheetLayoutProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;

public class FastHtmlExportTemplate
implements FastExportTemplate {
    private FastHtmlContentItems contentItems;
    private SheetLayout sharedSheetLayout;
    private FastExportTemplate processor;

    public FastHtmlExportTemplate(FastHtmlContentItems contentItems) {
        this.contentItems = contentItems;
    }

    @Override
    public void initialize(ReportDefinition report, ExpressionRuntime runtime, boolean pagination) {
        OutputProcessorMetaData metaData = runtime.getProcessingContext().getOutputProcessorMetaData();
        if (pagination) {
            this.sharedSheetLayout = new SheetLayout(metaData);
            this.processor = new FastSheetLayoutProducer(this.sharedSheetLayout);
            this.processor.initialize(report, runtime, pagination);
        } else {
            this.processor = new FastHtmlContentProducerTemplate(this.sharedSheetLayout, this.contentItems);
            this.processor.initialize(report, runtime, pagination);
        }
    }

    @Override
    public void write(Band band, ExpressionRuntime runtime) throws InvalidReportStateException {
        try {
            this.processor.write(band, runtime);
        }
        catch (InvalidReportStateException re) {
            throw re;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("Other failure", e);
        }
    }

    @Override
    public void finishReport() throws ReportProcessingException {
        this.processor.finishReport();
    }
}

