/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.xls;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.AbstractContentProducerTemplate;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastExportTemplateProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelTemplateProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;

public class FastExcelContentProducerTemplate
extends AbstractContentProducerTemplate {
    private final OutputStream outputStream;
    private final boolean useXlsx;
    private FastExcelPrinter excelPrinter;

    public FastExcelContentProducerTemplate(SheetLayout sheetLayout, OutputStream outputStream, boolean useXlsx) {
        super(sheetLayout);
        this.outputStream = outputStream;
        this.useXlsx = useXlsx;
    }

    @Override
    public void initialize(ReportDefinition report, ExpressionRuntime runtime, boolean pagination) {
        super.initialize(report, runtime, pagination);
        this.excelPrinter = new FastExcelPrinter(this.getSharedSheetLayout());
        this.excelPrinter.setUseXlsxFormat(this.useXlsx);
        this.excelPrinter.init(this.getMetaData(), runtime.getProcessingContext().getResourceManager(), report);
    }

    @Override
    protected void writeContent(Band band, ExpressionRuntime runtime, FormattedDataBuilder messageFormatSupport) throws IOException, ReportProcessingException, ContentProcessingException {
        messageFormatSupport.compute(band, runtime, this.outputStream);
    }

    @Override
    public void finishReport() throws ReportProcessingException {
        try {
            this.excelPrinter.closeWorkbook(this.outputStream);
        }
        catch (IOException e) {
            throw new ReportProcessingException("Failed to close report", e);
        }
    }

    @Override
    protected FastExportTemplateProducer createTemplateProducer() {
        return new FastExcelTemplateProducer(this.getMetaData(), this.getSharedSheetLayout(), this.excelPrinter);
    }
}

