/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.xls;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.ExcelReportUtil;

public class FastExcelReportUtil {
    private FastExcelReportUtil() {
    }

    public static void processXls(MasterReport report, OutputStream out) throws ReportProcessingException, IOException {
        FastExcelReportUtil.processXls(report, out, null);
    }

    public static void processXlsx(MasterReport report, OutputStream out) throws ReportProcessingException, IOException {
        FastExcelReportUtil.processXlsx(report, out, null);
    }

    public static void processXls(MasterReport report, OutputStream out, ReportProgressListener listener) throws ReportProcessingException, IOException {
        ReportStructureValidator validator = new ReportStructureValidator();
        if (!validator.isValidForFastProcessing(report)) {
            ExcelReportUtil.createXLS(report, out, listener);
            return;
        }
        FastExcelExportProcessor reportProcessor = new FastExcelExportProcessor(report, out, false);
        if (listener != null) {
            reportProcessor.addReportProgressListener(listener);
        }
        FastExcelReportUtil.doProcess(listener, reportProcessor);
        out.flush();
    }

    public static void processXlsx(MasterReport report, OutputStream out, ReportProgressListener listener) throws ReportProcessingException, IOException {
        ReportStructureValidator validator = new ReportStructureValidator();
        if (!validator.isValidForFastProcessing(report)) {
            ExcelReportUtil.createXLSX(report, out, listener);
            return;
        }
        FastExcelExportProcessor reportProcessor = new FastExcelExportProcessor(report, out, true);
        if (listener != null) {
            reportProcessor.addReportProgressListener(listener);
        }
        FastExcelReportUtil.doProcess(listener, reportProcessor);
        out.flush();
    }

    private static void doProcess(ReportProgressListener listener, FastExcelExportProcessor reportProcessor) throws ReportProcessingException {
        try {
            reportProcessor.processReport();
        }
        finally {
            if (listener != null) {
                reportProcessor.removeReportProgressListener(listener);
            }
            reportProcessor.close();
        }
    }
}

