/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal;

import com.lowagie.text.BadElementException;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class PdfImageHandler {
    private static final Log logger = LogFactory.getLog(PdfImageHandler.class);
    private LFUMap<ResourceKey, com.lowagie.text.Image> imageCache;
    private ResourceManager resourceManager;
    private OutputProcessorMetaData metaData;

    public PdfImageHandler(OutputProcessorMetaData metaData, ResourceManager resourceManager, LFUMap<ResourceKey, com.lowagie.text.Image> imageCache) {
        this.metaData = metaData;
        this.resourceManager = resourceManager;
        this.imageCache = imageCache;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public com.lowagie.text.Image createImage(RenderableReplacedContentBox content) {
        try {
            ImageContainer imageContainer;
            Object image;
            Object o = content.getContent().getRawObject();
            if (o instanceof DrawableWrapper) {
                DrawableWrapper drawableWrapper = (DrawableWrapper)o;
                StrictBounds bounds = new StrictBounds(content.getX(), content.getY(), content.getWidth(), content.getHeight());
                DefaultImageReference imageContainer2 = RenderUtility.createImageFromDrawable(drawableWrapper, bounds, content.getStyleSheet(), this.metaData);
                return com.lowagie.text.Image.getInstance((Image)imageContainer2.getImage(), (Color)Color.WHITE);
            }
            if (o instanceof Image) {
                Image img = (Image)o;
                return com.lowagie.text.Image.getInstance((Image)img, (Color)Color.WHITE);
            }
            if (o instanceof URLImageContainer && (image = this.createImage((URLImageContainer)(imageContainer = (URLImageContainer)o))) != null) {
                return image;
            }
            if (o instanceof LocalImageContainer) {
                imageContainer = (LocalImageContainer)o;
                image = imageContainer.getImage();
                return com.lowagie.text.Image.getInstance((Image)image, (Color)Color.WHITE);
            }
            return null;
        }
        catch (IOException e) {
            logger.info((Object)"Unable to load image. Ignoring.", (Throwable)e);
        }
        catch (BadElementException e) {
            logger.info((Object)"Unable to load image. Ignoring.", (Throwable)e);
        }
        return null;
    }

    public com.lowagie.text.Image createImage(URLImageContainer imageContainer) {
        if (!imageContainer.isLoadable()) {
            logger.info((Object)("URL-image cannot be rendered, as it was declared to be not loadable: " + imageContainer.getSourceURLString()));
            return null;
        }
        ResourceKey resource = imageContainer.getResourceKey();
        if (resource == null) {
            logger.info((Object)"URL-image cannot be rendered, as it did not return a valid URL.");
            return null;
        }
        try {
            com.lowagie.text.Image instance;
            ResourceManager resourceManager = this.getResourceManager();
            com.lowagie.text.Image maybeImage = (com.lowagie.text.Image)this.imageCache.get((Object)resource);
            if (maybeImage != null) {
                instance = maybeImage;
            } else {
                ResourceData data = resourceManager.load(resource);
                instance = com.lowagie.text.Image.getInstance((byte[])data.getResource(resourceManager));
                this.imageCache.put((Object)resource, (Object)instance);
            }
            return instance;
        }
        catch (InvalidReportStateException re) {
            throw re;
        }
        catch (Exception e) {
            logger.info((Object)"URL-image cannot be rendered, as the image was not loadable.", (Throwable)e);
            return null;
        }
    }
}

