/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.csv;

import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.CSVPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.helper.CSVOutputProcessorMetaData;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;

public class StreamCSVOutputProcessor
extends AbstractTableOutputProcessor {
    private OutputProcessorMetaData metaData;
    private FlowSelector flowSelector;
    private CSVPrinter printer;

    public StreamCSVOutputProcessor(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.metaData = new CSVOutputProcessorMetaData(0);
        this.flowSelector = new DisplayAllFlowSelector();
        this.printer = new CSVPrinter();
        ContentLocation root = new StreamRepository(outputStream).getRoot();
        this.printer.setContentLocation(root);
        this.printer.setContentNameGenerator((NameGenerator)new DefaultNameGenerator(root));
    }

    @Override
    public void processingStarted(ReportDefinition report, ProcessingContext processingContext) {
        super.processingStarted(report, processingContext);
        this.printer.initialize(processingContext.getConfiguration());
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    protected FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    @Override
    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        this.printer.print(logicalPage, contentProducer, this.metaData, false);
    }

    @Override
    protected void updateTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox, TableContentProducer tableContentProducer, boolean performOutput) throws ContentProcessingException {
        this.printer.print(logicalPageBox, tableContentProducer, this.metaData, true);
    }

    public String getEncoding() {
        return this.printer.getEncoding();
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        this.printer.setEncoding(encoding);
    }

    @Override
    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        this.metaData.commit();
        this.printer.close();
    }
}

