/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base;

import java.awt.Color;
import java.awt.Stroke;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.util.StrokeUtility;
import org.pentaho.reporting.engine.classic.core.util.beans.ColorValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.xml.sax.Locator;

public final class ReportParserUtil {
    public static final String INCLUDE_PARSING_KEY = "::Include-parser";
    public static final Object INCLUDE_PARSING_VALUE = Boolean.TRUE;
    public static final String HELPER_OBJ_REPORT_NAME = "::Report";
    public static final String HELPER_OBJ_LEGACY_STYLES = "::Legacy-Styles";
    private static final Log logger = LogFactory.getLog(ReportParserUtil.class);
    private static boolean strictParsing = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.parser.base.StrictParseMode"));

    private ReportParserUtil() {
    }

    public static boolean isIncluded(RootXmlReadHandler rootXmlReadHandler) {
        return INCLUDE_PARSING_VALUE.equals(rootXmlReadHandler.getHelperObject(INCLUDE_PARSING_KEY));
    }

    public static ElementAlignment parseVerticalElementAlignment(String value, Locator locator) throws ParseException {
        if (value == null) {
            return null;
        }
        if ("top".equals(value = value.toLowerCase())) {
            return ElementAlignment.TOP;
        }
        if ("middle".equals(value)) {
            return ElementAlignment.MIDDLE;
        }
        if ("bottom".equals(value)) {
            return ElementAlignment.BOTTOM;
        }
        if (strictParsing) {
            throw new ParseException("Invalid vertical alignment", locator);
        }
        if (locator == null) {
            logger.warn((Object)"Invalid value encountered for vertical alignment attribute.");
        } else {
            logger.warn((Object)("Invalid value encountered for vertical alignment attribute. [Line: " + locator.getLineNumber() + " Column: " + locator.getColumnNumber() + "]"));
        }
        return ElementAlignment.TOP;
    }

    public static ElementAlignment parseHorizontalElementAlignment(String value, Locator locator) throws ParseException {
        if (value == null) {
            return null;
        }
        if ("left".equals(value = value.toLowerCase())) {
            return ElementAlignment.LEFT;
        }
        if ("center".equals(value)) {
            return ElementAlignment.CENTER;
        }
        if ("right".equals(value)) {
            return ElementAlignment.RIGHT;
        }
        if ("justify".equals(value)) {
            return ElementAlignment.JUSTIFY;
        }
        if (strictParsing) {
            throw new ParseException("Invalid horizontal alignment", locator);
        }
        if (locator == null) {
            logger.warn((Object)"Invalid value encountered for horizontal alignment attribute.");
        } else {
            logger.warn((Object)("Invalid value encountered for horizontal alignment attribute. [Line: " + locator.getLineNumber() + " Column: " + locator.getColumnNumber() + "]"));
        }
        return ElementAlignment.LEFT;
    }

    public static Float parseFloat(String value, Locator locator) throws ParseException {
        if (value == null) {
            return null;
        }
        try {
            return new Float(value);
        }
        catch (Exception ex) {
            throw new ParseException("Failed to parse value", locator);
        }
    }

    public static Boolean parseBoolean(String value, Locator locator) throws ParseException {
        if (value == null) {
            return null;
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        if (strictParsing) {
            throw new ParseException("Failed to parse value", locator);
        }
        if (locator == null) {
            logger.warn((Object)"Invalid value encountered for boolean attribute.");
        } else {
            logger.warn((Object)("Invalid value encountered for boolean attribute. [Line: " + locator.getLineNumber() + " Column: " + locator.getColumnNumber() + "]"));
        }
        return Boolean.FALSE;
    }

    public static Integer parseInteger(String value, Locator locator) throws ParseException {
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (Exception ex) {
            throw new ParseException("Failed to parse value", locator);
        }
    }

    public static Color parseColor(String color) {
        return ReportParserUtil.parseColor(color, Color.black);
    }

    public static Color parseColor(String color, Color defaultValue) {
        if (color == null) {
            return defaultValue;
        }
        try {
            return (Color)new ColorValueConverter().toPropertyValue(color);
        }
        catch (Exception nfe) {
            return defaultValue;
        }
    }

    public static float parseRelativeFloat(String value, String exceptionMessage, Locator locator) throws ParseException {
        if (value == null) {
            throw new ParseException(exceptionMessage, locator);
        }
        if ("auto".equalsIgnoreCase(value)) {
            return -9.223372E18f;
        }
        String tvalue = value.trim();
        if (tvalue.length() > 0 && tvalue.charAt(tvalue.length() - 1) == '%') {
            String number = tvalue.substring(0, tvalue.length() - 1);
            return ParserUtil.parseFloat((String)number, (String)exceptionMessage, (Locator)locator) * -1.0f;
        }
        return ParserUtil.parseFloat((String)tvalue, (String)exceptionMessage, (Locator)locator);
    }

    public static Stroke parseStroke(String strokeStyle, float weight) {
        if ("dashed".equalsIgnoreCase(strokeStyle)) {
            return StrokeUtility.createStroke(1, weight);
        }
        if ("dotted".equalsIgnoreCase(strokeStyle)) {
            return StrokeUtility.createStroke(2, weight);
        }
        if ("dot-dot-dash".equalsIgnoreCase(strokeStyle)) {
            return StrokeUtility.createStroke(4, weight);
        }
        if ("dot-dash".equalsIgnoreCase(strokeStyle)) {
            return StrokeUtility.createStroke(3, weight);
        }
        return StrokeUtility.createStroke(0, weight);
    }

    public static VerticalTextAlign parseVerticalTextElementAlignment(String value, Locator locator) throws ParseException {
        if (value == null) {
            return null;
        }
        if ("top".equals(value)) {
            return VerticalTextAlign.TOP;
        }
        if ("middle".equals(value)) {
            return VerticalTextAlign.MIDDLE;
        }
        if ("bottom".equals(value)) {
            return VerticalTextAlign.BOTTOM;
        }
        if ("baseline".equals(value)) {
            return VerticalTextAlign.BASELINE;
        }
        if ("central".equals(value)) {
            return VerticalTextAlign.CENTRAL;
        }
        if ("sub".equals(value)) {
            return VerticalTextAlign.SUB;
        }
        if ("super".equals(value)) {
            return VerticalTextAlign.SUPER;
        }
        if ("text-bottom".equals(value)) {
            return VerticalTextAlign.TEXT_BOTTOM;
        }
        if ("text-top".equals(value)) {
            return VerticalTextAlign.TEXT_TOP;
        }
        if ("use-script".equals(value)) {
            return VerticalTextAlign.USE_SCRIPT;
        }
        throw new ParseException("Invalid vertical alignment", locator);
    }

    public static int parseVersion(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return -1;
        }
        try {
            StringTokenizer strtok = new StringTokenizer(s, ".");
            int version = 0;
            while (strtok.hasMoreElements()) {
                String token = strtok.nextToken();
                int i = Integer.parseInt(token);
                version = version * 1000 + i;
            }
            return version;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

