/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyStringReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.StringValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.SAXException;

public class PropertyReferenceReadHandler
extends PropertyStringReadHandler {
    private static final Log logger = LogFactory.getLog(PropertyReferenceReadHandler.class);
    private static final String CLASS_ATT = "class";
    private static final String NAME_ATT = "name";
    private String propertyName;
    private Object value;
    private ValueConverter valueType;

    @Override
    public void startParsing(PropertyAttributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.propertyName = attrs.getValue(this.getUri(), NAME_ATT);
        if (this.propertyName == null) {
            throw new ParseException("Required attribute 'name' is null.", this.getLocator());
        }
        String className = CompatibilityMapperUtil.mapClassName(attrs.getValue(this.getUri(), CLASS_ATT));
        if (className == null) {
            this.valueType = new StringValueConverter();
        } else {
            try {
                ClassLoader classLoader = ObjectUtilities.getClassLoader(this.getClass());
                Class<?> c = Class.forName(className);
                this.valueType = ConverterRegistry.getInstance().getValueConverter(c);
                if (this.valueType == null) {
                    logger.warn((Object)("Unable to find a suitable value-converter for " + c));
                    this.valueType = new StringValueConverter();
                }
            }
            catch (Exception e) {
                throw new SAXException("Attribute 'class' is invalid.");
            }
        }
    }

    @Override
    public void doneParsing() throws SAXException {
        super.doneParsing();
        String result = this.getResult();
        boolean strictPropertyErrorHandling = result.trim().length() != 0;
        try {
            this.value = this.valueType.toPropertyValue(result);
        }
        catch (BeanException e) {
            if (strictPropertyErrorHandling) {
                throw new ParseException("Failed to parse property value for property " + this.propertyName, (Exception)e);
            }
            logger.warn((Object)("Failed to parse property value for property: " + this.propertyName), (Throwable)e);
        }
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

