/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data.ListParameterReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data.PlainParameterReadHandler;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MasterParameterDefinitionReadHandler
extends AbstractXmlReadHandler {
    private DefaultParameterDefinition parameterDefinition;
    private ArrayList parameterReadHandlers = new ArrayList();

    public MasterParameterDefinitionReadHandler() {
        this.parameterDefinition = new DefaultParameterDefinition();
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String validatorClass = attrs.getValue(this.getUri(), "validator");
        if (validatorClass == null) {
            this.parameterDefinition.setValidator(new DefaultReportParameterValidator());
        } else {
            Object o = ObjectUtilities.loadAndInstantiate((String)CompatibilityMapperUtil.mapClassName(validatorClass), ((Object)((Object)this)).getClass(), ReportParameterValidator.class);
            if (o == null) {
                throw new ParseException("Valud given for 'validator' is invalid", this.getLocator());
            }
            this.parameterDefinition.setValidator((ReportParameterValidator)o);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("plain-parameter".equals(tagName)) {
            PlainParameterReadHandler readHandler = new PlainParameterReadHandler();
            this.parameterReadHandlers.add(readHandler);
            return readHandler;
        }
        if ("single-selection-parameter".equals(tagName)) {
            ListParameterReadHandler readHandler = new ListParameterReadHandler();
            this.parameterReadHandlers.add(readHandler);
            return readHandler;
        }
        if ("list-parameter".equals(tagName)) {
            ListParameterReadHandler readHandler = new ListParameterReadHandler();
            this.parameterReadHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.parameterReadHandlers.size(); ++i) {
            XmlReadHandler handler = (XmlReadHandler)this.parameterReadHandlers.get(i);
            this.parameterDefinition.addParameterDefinition((ParameterDefinitionEntry)handler.getObject());
        }
    }

    public Object getObject() throws SAXException {
        return this.parameterDefinition;
    }
}

