/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base;

import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;

public class Ellipse2DObjectDescription
extends AbstractObjectDescription {
    public Ellipse2DObjectDescription() {
        super(Ellipse2D.class);
        this.setParameterDefinition("width", Float.class);
        this.setParameterDefinition("height", Float.class);
        this.setParameterDefinition("x", Float.class);
        this.setParameterDefinition("y", Float.class);
    }

    @Override
    public Object createObject() {
        Ellipse2D.Float rect = new Ellipse2D.Float();
        float w = this.getFloatParameter("width");
        float h = this.getFloatParameter("height");
        float x = this.getFloatParameter("x");
        float y = this.getFloatParameter("y");
        ((RectangularShape)rect).setFrame(x, y, w, h);
        return rect;
    }

    private float getFloatParameter(String param) {
        Float p = (Float)this.getParameter(param);
        if (p == null) {
            return 0.0f;
        }
        return p.floatValue();
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof Ellipse2D)) {
            throw new ObjectFactoryException("The given object is no java.awt.geom.Rectangle2D.");
        }
        Ellipse2D rect = (Ellipse2D)o;
        float x = (float)rect.getX();
        float y = (float)rect.getY();
        float w = (float)rect.getWidth();
        float h = (float)rect.getHeight();
        this.setParameter("x", new Float(x));
        this.setParameter("y", new Float(y));
        this.setParameter("width", new Float(w));
        this.setParameter("height", new Float(h));
    }
}

