/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates;

import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.filter.templates.Template;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateCollection;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateDescription;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class TemplateCollector
extends TemplateCollection {
    private final ArrayList factories = new ArrayList();

    public void addTemplateCollection(TemplateCollection tc) {
        if (tc == null) {
            throw new NullPointerException();
        }
        this.factories.add(tc);
        if (this.getConfig() != null) {
            tc.configure(this.getConfig());
        }
    }

    public Iterator getFactories() {
        return this.factories.iterator();
    }

    @Override
    public TemplateDescription getTemplate(String name) {
        for (int i = 0; i < this.factories.size(); ++i) {
            TemplateCollection fact = (TemplateCollection)this.factories.get(i);
            TemplateDescription o = fact.getTemplate(name);
            if (o == null) continue;
            return o;
        }
        return super.getTemplate(name);
    }

    @Override
    public TemplateDescription getDescription(Template template) {
        for (int i = 0; i < this.factories.size(); ++i) {
            TemplateCollection fact = (TemplateCollection)this.factories.get(i);
            TemplateDescription o = fact.getDescription(template);
            if (o == null) continue;
            return o;
        }
        return super.getDescription(template);
    }

    @Override
    public void configure(Configuration config) {
        if (this.getConfig() != null) {
            return;
        }
        super.configure(config);
        for (TemplateCollection od : this.factories) {
            od.configure(config);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateCollector)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateCollector templateCollector = (TemplateCollector)o;
        return this.factories.equals(templateCollector.factories);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.factories.hashCode();
        return result;
    }
}

