/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.GroupList;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.GroupFieldsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.RootBandReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class GroupReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String GROUP_HEADER_TAG = "group-header";
    public static final String GROUP_FOOTER_TAG = "group-footer";
    public static final String FIELDS_TAG = "fields";
    public static final String FIELD_TAG = "field";
    private static final String NAME_ATT = "name";
    private GroupList groupList;
    private RelationalGroup group;

    public GroupReadHandler(GroupList groupList) {
        this.groupList = groupList;
    }

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String groupName = attrs.getValue(this.getUri(), NAME_ATT);
        if (groupName != null) {
            AbstractReportDefinition report = (AbstractReportDefinition)this.getRootHandler().getHelperObject("::Report");
            RelationalGroup maybeDefaultGroup = report.getGroupByName(groupName);
            if (maybeDefaultGroup instanceof RelationalGroup) {
                this.group = maybeDefaultGroup;
            } else {
                this.group = new RelationalGroup();
                this.group.setName(groupName);
                this.group.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", this.getRootHandler().getSource());
            }
        } else {
            this.group = new RelationalGroup();
            this.group.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", this.getRootHandler().getSource());
        }
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if (tagName.equals(GROUP_HEADER_TAG)) {
            return new RootBandReadHandler(this.group.getHeader());
        }
        if (tagName.equals(GROUP_FOOTER_TAG)) {
            return new RootBandReadHandler(this.group.getFooter());
        }
        if (tagName.equals(FIELDS_TAG)) {
            return new GroupFieldsReadHandler(this.group);
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.groupList.add(this.group);
    }

    public Object getObject() {
        return this.group;
    }
}

