/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.util.LinkedHashMap;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.libraries.base.util.LinkedMap;

public class CompoundDataRow
implements DataRow {
    private LinkedHashMap<String, Boolean> columnSources;
    private DataRow envDataRow;
    private DataRow dataRow;

    public CompoundDataRow(DataRow envDataRow, DataRow dataRow) {
        this.envDataRow = envDataRow;
        this.dataRow = dataRow;
        this.columnSources = new LinkedHashMap();
        String[] dataRowNames = dataRow.getColumnNames();
        for (int i = 0; i < dataRowNames.length; ++i) {
            String dataRowName = dataRowNames[i];
            this.columnSources.put(dataRowName, Boolean.TRUE);
        }
        String[] envRowNames = envDataRow.getColumnNames();
        for (int i = 0; i < envRowNames.length; ++i) {
            String dataRowName = envRowNames[i];
            this.columnSources.put(dataRowName, Boolean.FALSE);
        }
    }

    public DataRow getEnvDataRow() {
        return this.envDataRow;
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    @Override
    public Object get(String col) {
        Boolean b = this.columnSources.get(col);
        if (Boolean.FALSE.equals(b)) {
            return this.envDataRow.get(col);
        }
        return this.dataRow.get(col);
    }

    @Override
    public String[] getColumnNames() {
        LinkedMap columnSources = new LinkedMap();
        String[] dataRowNames = this.dataRow.getColumnNames();
        for (int i = 0; i < dataRowNames.length; ++i) {
            String dataRowName = dataRowNames[i];
            columnSources.put((Object)dataRowName, (Object)Boolean.TRUE);
        }
        String[] envRowNames = this.envDataRow.getColumnNames();
        for (int i = 0; i < envRowNames.length; ++i) {
            String dataRowName = envRowNames[i];
            columnSources.put((Object)dataRowName, (Object)Boolean.FALSE);
        }
        return (String[])columnSources.keys((Object[])new String[columnSources.size()]);
    }

    @Override
    public boolean isChanged(String name) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompoundDataRow");
        sb.append("{envDataRow=").append(this.envDataRow);
        sb.append(", dataRow=").append(this.dataRow);
        sb.append('}');
        return sb.toString();
    }
}

