/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.sorting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;

public class SortOrderReportPreProcessor
extends AbstractReportPreProcessor {
    @Override
    public MasterReport performPreDataProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        return this.performInternalPreDataProcessing(definition);
    }

    @Override
    public SubReport performPreDataProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        return this.performInternalPreDataProcessing(definition);
    }

    protected <T extends AbstractReportDefinition> T performInternalPreDataProcessing(T report) {
        Boolean attribute = report.getAutoSort();
        if (!Boolean.TRUE.equals(attribute)) {
            return report;
        }
        List<SortConstraint> sort = this.computeSortConstraints(report);
        report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "computed-sort-constraints", Collections.unmodifiableList(sort));
        return report;
    }

    public List<SortConstraint> computeSortConstraints(AbstractReportDefinition report) {
        return this.collectSortData(report.getRootGroup(), new ArrayList<SortConstraint>());
    }

    private List<SortConstraint> collectSortData(Group rootGroup, ArrayList<SortConstraint> sorts) {
        sorts.addAll(rootGroup.getSortingConstraint());
        GroupBody body = rootGroup.getBody();
        Group group = body.getGroup();
        if (group == null) {
            return sorts;
        }
        return this.collectSortData(group, sorts);
    }
}

