/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.states.FunctionStorageKey;

public class DataFactoryManager
implements Serializable {
    private HashMap<Object, CachingDataFactory> storage = new HashMap();

    public void store(FunctionStorageKey key, CachingDataFactory expressions, boolean perDeclaration) throws ReportProcessingException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (expressions == null) {
            throw new NullPointerException();
        }
        if (perDeclaration) {
            this.storage.put(key.getReportId(), expressions);
        } else {
            this.storage.put(key, expressions);
        }
    }

    public CachingDataFactory restore(FunctionStorageKey key, boolean perDeclaration) throws ReportProcessingException {
        if (key == null) {
            throw new NullPointerException();
        }
        CachingDataFactory expressions = perDeclaration ? this.storage.get(key.getReportId()) : this.storage.get(key);
        if (expressions == null) {
            return null;
        }
        return expressions;
    }

    public void close() {
        DataFactory[] objects = this.storage.values().toArray(new DataFactory[this.storage.size()]);
        for (int i = 0; i < objects.length; ++i) {
            DataFactory object = objects[i];
            object.close();
        }
    }
}

