/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.event.ReportEvent;

public class ReportStateKey {
    private ReportStateKey parent;
    private int cursor;
    private int stateCode;
    private int groupLevel;
    private int subreport;
    private Integer hashCode;
    private int sequenceCounter;
    private boolean restoreState;
    private boolean inlineSubReportState;

    public ReportStateKey() {
    }

    public ReportStateKey(ReportStateKey parent, int cursor, int stateCode, int groupLevel, int subreport, int sequenceCounter, boolean restoreState, boolean inlineSubReportState) {
        this.parent = parent;
        this.cursor = cursor;
        this.stateCode = stateCode;
        this.groupLevel = groupLevel;
        this.subreport = subreport;
        this.sequenceCounter = sequenceCounter;
        this.restoreState = restoreState;
        this.inlineSubReportState = inlineSubReportState;
    }

    public int getSequenceCounter() {
        return this.sequenceCounter;
    }

    public ReportStateKey getParent() {
        return this.parent;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getStateCode() {
        return this.stateCode;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public int getSubreport() {
        return this.subreport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportStateKey that = (ReportStateKey)o;
        if (this.restoreState != that.restoreState) {
            return false;
        }
        if (this.cursor != that.cursor) {
            return false;
        }
        if (this.groupLevel != that.groupLevel) {
            return false;
        }
        if (this.stateCode != that.stateCode) {
            return false;
        }
        if (this.subreport != that.subreport) {
            return false;
        }
        return !(this.parent != null ? !this.parent.equals(that.parent) : that.parent != null);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 29 * result + this.cursor;
            result = 29 * result + this.stateCode;
            result = 29 * result + this.groupLevel;
            result = 29 * result + this.subreport;
            result = 29 * result + (this.restoreState ? 1 : 0);
            result = 29 * result + (this.inlineSubReportState ? 1 : 0);
            this.hashCode = result;
            return result;
        }
        return this.hashCode;
    }

    public boolean isInlineSubReportState() {
        return this.inlineSubReportState;
    }

    public String toString() {
        return "ReportStateKey{sc=" + this.sequenceCounter + ", cursor=" + this.cursor + ", groupLevel=" + this.groupLevel + ", subreport=" + this.subreport + ", stateCode=" + ReportEvent.translateStateCode(this.stateCode) + ", restoreState=" + this.restoreState + ", inlineSubReport=" + this.inlineSubReportState + ", stateCodeRaw=0x" + Integer.toHexString(this.stateCode) + ", parent=" + this.parent + '}';
    }
}

