/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.awt.Font;
import java.io.Serializable;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class FontDefinition
implements Serializable,
Cloneable {
    public static final boolean BOLD = true;
    public static final boolean ITALIC = true;
    public static final boolean UNDERLINE = true;
    public static final boolean STRIKETHROUGH = true;
    public static final boolean PLAIN = false;
    private String fontEncoding;
    private String fontName;
    private int fontSize;
    private boolean isBold;
    private boolean isItalic;
    private boolean isUnderline;
    private boolean isStrikeThrough;
    private transient Font font;
    private boolean embeddedFont;
    private transient int hashCode;

    public FontDefinition(String fontName, int fontSize, boolean bold, boolean italic, boolean underline, boolean strikeThrough, String encoding, boolean embedded) {
        if (fontName == null) {
            throw new NullPointerException("FontName must not be null");
        }
        if (fontSize <= 0) {
            throw new IllegalArgumentException("FontSize must be greater than 0");
        }
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.isBold = bold;
        this.isItalic = italic;
        this.isUnderline = underline;
        this.isStrikeThrough = strikeThrough;
        this.fontEncoding = encoding;
        this.embeddedFont = embedded;
    }

    public FontDefinition(String fontName, int fontSize, boolean bold, boolean italic, boolean underline, boolean strikeThrough) {
        this(fontName, fontSize, bold, italic, underline, strikeThrough, null, false);
    }

    public FontDefinition(String fontName, int fontSize) {
        this(fontName, fontSize, false, false, false, false, null, false);
    }

    public FontDefinition(Font font) {
        this(font.getName(), font.getSize(), font.isBold(), font.isItalic(), false, false, null, false);
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public boolean isEmbeddedFont() {
        return this.embeddedFont;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public boolean isUnderline() {
        return this.isUnderline;
    }

    public boolean isStrikeThrough() {
        return this.isStrikeThrough;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private int getFontStyle() {
        int fontstyle = 0;
        if (this.isBold()) {
            ++fontstyle;
        }
        if (this.isItalic()) {
            fontstyle += 2;
        }
        return fontstyle;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font(this.getFontName(), this.getFontStyle(), this.getFontSize());
        }
        return this.font;
    }

    public String getFontEncoding(String defaultEncoding) {
        if (this.fontEncoding == null) {
            return defaultEncoding;
        }
        return this.fontEncoding;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FontDefinition='fontname=\"");
        buffer.append(this.fontName);
        buffer.append("\"; fontSize=");
        buffer.append(this.fontSize);
        buffer.append("; bold=");
        buffer.append(this.isBold);
        buffer.append("; italic=");
        buffer.append(this.isItalic);
        buffer.append("; underline=");
        buffer.append(this.isUnderline);
        buffer.append("; strike=");
        buffer.append(this.isStrikeThrough);
        buffer.append("; embedded=");
        buffer.append(this.embeddedFont);
        buffer.append('\'');
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FontDefinition)) {
            return false;
        }
        FontDefinition definition = (FontDefinition)o;
        if (this.embeddedFont != definition.embeddedFont) {
            return false;
        }
        if (this.fontSize != definition.fontSize) {
            return false;
        }
        if (this.isBold != definition.isBold) {
            return false;
        }
        if (this.isItalic != definition.isItalic) {
            return false;
        }
        if (this.isStrikeThrough != definition.isStrikeThrough) {
            return false;
        }
        if (this.isUnderline != definition.isUnderline) {
            return false;
        }
        if (!this.fontName.equals(definition.fontName)) {
            return false;
        }
        return !(this.fontEncoding != null ? !this.fontEncoding.equals(definition.fontEncoding) : definition.fontEncoding != null);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.fontEncoding != null ? this.fontEncoding.hashCode() : 0;
            result = 29 * result + this.fontName.hashCode();
            result = 29 * result + this.fontSize;
            result = 29 * result + (this.isBold ? 1 : 0);
            result = 29 * result + (this.isItalic ? 1 : 0);
            result = 29 * result + (this.isUnderline ? 1 : 0);
            result = 29 * result + (this.isStrikeThrough ? 1 : 0);
            this.hashCode = result = 29 * result + (this.embeddedFont ? 1 : 0);
        }
        return this.hashCode;
    }

    public boolean isSansSerif() {
        return StringUtils.startsWithIgnoreCase((String)this.fontName, (String)"SansSerif") || StringUtils.startsWithIgnoreCase((String)this.fontName, (String)"Dialog") || StringUtils.startsWithIgnoreCase((String)this.fontName, (String)"SanSerif");
    }

    public boolean isCourier() {
        return StringUtils.startsWithIgnoreCase((String)this.fontName, (String)"dialoginput") || StringUtils.startsWithIgnoreCase((String)this.fontName, (String)"monospaced");
    }

    public boolean isSerif() {
        return StringUtils.startsWithIgnoreCase((String)this.fontName, (String)"serif");
    }
}

