/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import org.pentaho.reporting.engine.classic.core.util.ObjectStreamResolveException;

public class TextRotation
implements Serializable {
    public static final TextRotation D_90 = new TextRotation("90");
    public static final TextRotation D_270 = new TextRotation("-90");
    private static final String CSS = "transform: rotate({0}deg); -ms-transform: rotate({0}deg); -webkit-transform: rotate({0}deg); {1}";
    private static final String CSS_POS = "white-space: nowrap; {0}";
    private static final String CSS_90 = "transform-origin: right bottom;";
    private static final String CSS_270 = "transform-origin: left bottom;";
    private String type;

    private TextRotation(String type) {
        this.type = type;
    }

    public static TextRotation getInstance(short degree) {
        if (degree > 0) {
            return D_90;
        }
        if (degree < 0) {
            return D_270;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextRotation that = (TextRotation)o;
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public String toString() {
        return this.type;
    }

    public short getNumericValue() {
        if (this.type.equals(TextRotation.D_90.type)) {
            return 90;
        }
        if (this.type.equals(TextRotation.D_270.type)) {
            return -90;
        }
        return 0;
    }

    public String getCss() {
        return MessageFormat.format(CSS, -this.getNumericValue(), MessageFormat.format(CSS_POS, this.getNumericValue() > 0 ? CSS_90 : CSS_270));
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.type.equals(TextRotation.D_90.type)) {
            return D_90;
        }
        if (this.type.equals(TextRotation.D_270.type)) {
            return D_270;
        }
        throw new ObjectStreamResolveException();
    }
}

