/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.css.selector;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.selector.AbstractSelector;
import org.pentaho.reporting.engine.classic.core.style.css.selector.SelectorWeight;
import org.w3c.css.sac.ElementSelector;

public class CSSElementSelector
extends AbstractSelector
implements ElementSelector,
Serializable {
    private short selectorType;
    private String namespace;
    private String localName;

    public CSSElementSelector(short selectorType, String namespace, String localName) {
        this.selectorType = selectorType;
        this.namespace = namespace;
        this.localName = localName;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public short getSelectorType() {
        return this.selectorType;
    }

    @Override
    protected SelectorWeight createWeight() {
        return new SelectorWeight(0, 0, 0, 1);
    }

    @Override
    public String print(NamespaceCollection namespaces) {
        StringBuilder b = new StringBuilder();
        if (this.namespace != null) {
            if ("*".equals(this.namespace)) {
                b.append("*|");
            } else if ("".equals(this.namespace)) {
                b.append("|");
            } else {
                NamespaceDefinition definition = namespaces.getDefinition(this.namespace);
                if (definition == null) {
                    b.append("\"");
                    b.append(this.namespace);
                    b.append("\"");
                    b.append("|");
                } else {
                    b.append(definition.getPrefix());
                    b.append("|");
                }
            }
            b.append(this.localName);
        } else if (this.localName != null) {
            b.append(this.localName);
        }
        return b.toString();
    }
}

