/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.resolver;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.resolver.StyleResolver;
import org.pentaho.reporting.engine.classic.core.util.DoubleKeyedCounter;
import org.pentaho.reporting.engine.classic.core.util.SingleKeyedCounter;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class SimpleStyleResolver
implements StyleResolver {
    private SingleKeyedCounter<String> usageCounter;
    private DoubleKeyedCounter<String, Long> extendedCounter;
    private boolean designTime;

    public SimpleStyleResolver() {
        this(false);
    }

    public SimpleStyleResolver(boolean designTime) {
        this.designTime = designTime;
        this.usageCounter = new SingleKeyedCounter();
        this.extendedCounter = new DoubleKeyedCounter();
    }

    public static SimpleStyleSheet resolveOneTime(ReportElement element) {
        SimpleStyleResolver styleResolver = new SimpleStyleResolver(true);
        ResolverStyleSheet resolverTarget = new ResolverStyleSheet();
        styleResolver.resolve(element, resolverTarget);
        return new SimpleStyleSheet(resolverTarget);
    }

    @Override
    public void resolve(ReportElement element, ResolverStyleSheet resolverTarget) {
        resolverTarget.clear();
        resolverTarget.setId(element.getStyle().getId());
        this.resolveParent(element, resolverTarget);
        resolverTarget.addAll(element.getStyle());
        resolverTarget.addDefault(element.getDefaultStyleSheet());
    }

    public void resolveParent(ReportElement element, ElementStyleSheet resolverTarget) {
        Section section;
        if (!this.designTime) {
            Section parentSection = element.getParentSection();
            if (parentSection == null) {
                return;
            }
            SimpleStyleSheet computedStyle = parentSection.getComputedStyle();
            resolverTarget.addInherited(computedStyle);
        }
        FastStack parentSections = new FastStack();
        ReportElement e = element;
        while (e.getParentSection() != null) {
            section = e.getParentSection();
            parentSections.push((Object)section);
            e = section;
        }
        while (!parentSections.isEmpty()) {
            section = (Section)parentSections.pop();
            resolverTarget.addInherited(section.getStyle());
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.usageCounter.printStatistic());
        b.append(this.extendedCounter.printStatistic());
        return b.toString();
    }

    @Override
    public SimpleStyleResolver clone() {
        try {
            return (SimpleStyleResolver)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

