/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class LevelList
implements Cloneable {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];
    private static final Integer ZERO = new Integer(0);
    private transient TreeSet iteratorSetAsc;
    private transient TreeSet iteratorSetDesc;
    private HashMap iteratorCache;
    private ArrayList elements = new ArrayList();
    private ArrayList levels = new ArrayList();

    public LevelList() {
        this.iteratorCache = new HashMap();
    }

    public int size() {
        return this.elements.size();
    }

    public Iterator getLevelsAscending() {
        if (this.iteratorSetAsc == null) {
            this.iteratorSetAsc = new TreeSet();
            Integer[] ilevels = this.levels.toArray(new Integer[this.levels.size()]);
            for (int i = 0; i < ilevels.length; ++i) {
                if (this.iteratorSetAsc.contains(ilevels[i])) continue;
                this.iteratorSetAsc.add(ilevels[i]);
            }
        }
        return this.iteratorSetAsc.iterator();
    }

    public Integer[] getLevelsDescendingArray() {
        if (this.levels.isEmpty()) {
            return EMPTY_INTEGER_ARRAY;
        }
        if (this.iteratorSetDesc == null) {
            Integer[] ilevels = this.levels.toArray(new Integer[this.levels.size()]);
            this.iteratorSetDesc = new TreeSet(new DescendingComparator());
            for (int i = 0; i < ilevels.length; ++i) {
                if (this.iteratorSetDesc.contains(ilevels[i])) continue;
                this.iteratorSetDesc.add(ilevels[i]);
            }
        }
        return this.iteratorSetDesc.toArray(new Integer[this.iteratorSetDesc.size()]);
    }

    public Iterator getLevelsDescending() {
        if (this.iteratorSetDesc == null) {
            this.iteratorSetDesc = new TreeSet(new DescendingComparator());
            Integer[] ilevels = this.levels.toArray(new Integer[this.levels.size()]);
            for (int i = 0; i < ilevels.length; ++i) {
                if (this.iteratorSetDesc.contains(ilevels[i])) continue;
                this.iteratorSetDesc.add(ilevels[i]);
            }
        }
        return this.iteratorSetDesc.iterator();
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public Object[] getElementArrayForLevel(int level, Object[] target) {
        ElementLevelList it = (ElementLevelList)this.iteratorCache.get(IntegerCache.getInteger(level));
        if (it == null) {
            it = new ElementLevelList(this, level);
            this.iteratorCache.put(IntegerCache.getInteger(level), it);
        }
        if (target == null) {
            return it.getData();
        }
        return it.getData(target);
    }

    public Object[] getElementArrayForLevel(int level) {
        return this.getElementArrayForLevel(level, null);
    }

    public int getElementCountForLevel(int level) {
        ElementLevelList it = (ElementLevelList)this.iteratorCache.get(IntegerCache.getInteger(level));
        if (it == null) {
            it = new ElementLevelList(this, level);
            this.iteratorCache.put(IntegerCache.getInteger(level), it);
        }
        return it.size();
    }

    protected Iterator getElementsForLevel(int level) {
        List<Object> list = Arrays.asList(this.getElementArrayForLevel(level));
        return Collections.unmodifiableList(list).iterator();
    }

    public Object get(int index) {
        return this.elements.get(index);
    }

    public void add(Object o) {
        this.elements.add(o);
        this.levels.add(ZERO);
        this.iteratorSetAsc = null;
        this.iteratorSetDesc = null;
        this.iteratorCache.remove(ZERO);
    }

    public void add(Object o, int level) {
        this.elements.add(o);
        Integer i = IntegerCache.getInteger(level);
        this.levels.add(i);
        this.iteratorCache.remove(i);
        this.iteratorSetAsc = null;
        this.iteratorSetDesc = null;
    }

    public void setLevel(int index, int level) {
        this.levels.set(index, IntegerCache.getInteger(level));
    }

    public int getLevel(int index) {
        return (Integer)this.levels.get(index);
    }

    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    public int getLevel(Object o) {
        return this.getLevel(this.indexOf(o));
    }

    public void setLevel(Object o, int level) {
        this.setLevel(this.indexOf(o), level);
    }

    public Object clone() throws CloneNotSupportedException {
        LevelList l = (LevelList)super.clone();
        l.elements = (ArrayList)this.elements.clone();
        l.levels = (ArrayList)this.levels.clone();
        l.iteratorCache = (HashMap)this.iteratorCache.clone();
        return l;
    }

    public void clear() {
        this.elements.clear();
        this.levels.clear();
        this.iteratorCache.clear();
        this.iteratorSetAsc = null;
        this.iteratorSetDesc = null;
    }

    protected Object[] getRawElements() {
        if (this.elements.isEmpty()) {
            return EMPTY_OBJECT_ARRAY;
        }
        return this.elements.toArray(new Object[this.elements.size()]);
    }

    protected Integer[] getRawLevels() {
        if (this.levels.isEmpty()) {
            return EMPTY_INTEGER_ARRAY;
        }
        return this.levels.toArray(new Integer[this.levels.size()]);
    }

    private static final class ElementLevelList {
        private Object[] data;

        private ElementLevelList(LevelList list, int level) {
            if (list == null) {
                throw new NullPointerException();
            }
            Object[] rawElements = list.getRawElements();
            Integer[] rawLevels = list.getRawLevels();
            ArrayList<Object> datalist = new ArrayList<Object>(rawElements.length);
            for (int i = 0; i < rawElements.length; ++i) {
                Object iNext = rawElements[i];
                Integer iLevel = rawLevels[i];
                if (iLevel != level) continue;
                datalist.add(iNext);
            }
            this.data = datalist.toArray();
        }

        protected Object[] getData() {
            return (Object[])this.data.clone();
        }

        protected Object[] getData(Object[] target) {
            if (target == null) {
                target = new Object[this.data.length];
            } else if (target.length < this.data.length) {
                target = (Object[])Array.newInstance(target.getClass().getComponentType(), this.data.length);
            }
            System.arraycopy(this.data, 0, target, 0, this.data.length);
            if (target.length > this.data.length) {
                target[this.data.length] = null;
            }
            return target;
        }

        protected int size() {
            return this.data.length;
        }
    }

    private static final class DescendingComparator
    implements Comparator,
    Serializable {
        private DescendingComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Comparable)) {
                throw new ClassCastException("Need comparable Elements");
            }
            if (!(o2 instanceof Comparable)) {
                throw new ClassCastException("Need comparable Elements");
            }
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return -1 * c1.compareTo(c2);
        }
    }
}

