/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.libraries.base.util.GenericObjectTable;

public class TypedTableModel
extends AbstractTableModel {
    private ArrayList<String> columnNames;
    private ArrayList<Class<?>> columnClasses;
    private GenericObjectTable<Object> data;

    public TypedTableModel() {
        this(10, 10);
    }

    public TypedTableModel(int rowIncrement, int columnIncrement) {
        this.data = new GenericObjectTable(Math.max(1, rowIncrement), Math.max(1, columnIncrement));
        this.columnNames = new ArrayList(columnIncrement);
        this.columnClasses = new ArrayList(columnIncrement);
    }

    public TypedTableModel(String[] columnNames) {
        this(10, columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            this.columnNames.add(columnName);
            this.columnClasses.add(Object.class);
        }
    }

    public TypedTableModel(String[] columnNames, Class<?>[] columnClasses) {
        this(columnNames, columnClasses, 10);
    }

    public TypedTableModel(String[] columnNames, Class<?>[] columnClasses, int rowCount) {
        this(rowCount, columnNames.length);
        if (columnNames.length != columnClasses.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            this.columnNames.add(columnName);
            this.columnClasses.add(columnClasses[i]);
        }
    }

    public void addColumn(String name, Class<?> type) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        this.columnNames.add(name);
        this.columnClasses.add(type);
    }

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses.get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.getObject(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.data.setObject(rowIndex, columnIndex, aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void setColumnType(int colIndex, Class<?> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.columnClasses.set(colIndex, type);
        this.fireTableStructureChanged();
    }

    public void setColumnName(int colIndex, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.columnNames.set(colIndex, name);
        this.fireTableStructureChanged();
    }

    public void addRow(Object ... objects) {
        int row = this.getRowCount();
        if (objects.length == 0) {
            this.setValueAt(null, row, 0);
        } else {
            int maxCols = Math.min(objects.length, this.getColumnCount());
            for (int i = 0; i < maxCols; ++i) {
                this.setValueAt(objects[i], row, i);
            }
        }
        this.fireTableDataChanged();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TypedTableModel");
        sb.append("{columnNames=").append(this.columnNames);
        sb.append(", columnClasses=").append(this.columnClasses);
        sb.append(", rowCount=").append(this.getRowCount());
        sb.append('}');
        return sb.toString();
    }
}

