/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.xml;

import de.schlichtherle.xml.GenericCertificateIntegrityException;
import de.schlichtherle.xml.GenericCertificateIsLockedException;
import de.schlichtherle.xml.GenericCertificateNotLockedException;
import de.schlichtherle.xml.PersistenceService;
import de.schlichtherle.xml.PersistenceServiceException;
import de.schlichtherle.xml.XMLConstants;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;

public final class GenericCertificate
implements Serializable,
XMLConstants {
    private static final long serialVersionUID = 6247620498526484734L;
    private static final String BASE64_CHARSET = "US-ASCII";
    private static final String SIGNATURE_ENCODING = "US-ASCII/Base64";
    private transient boolean locked;
    private String encoded;
    private String signature;
    private String signatureAlgorithm;
    private String signatureEncoding;
    private transient PropertyChangeSupport propertyChangeSupport;
    private transient VetoableChangeSupport vetoableChangeSupport;

    public GenericCertificate() {
    }

    public GenericCertificate(GenericCertificate cert) {
        try {
            this.setEncoded(cert.getEncoded());
            this.setSignature(cert.getSignature());
            this.setSignatureAlgorithm(cert.getSignatureAlgorithm());
            this.setSignatureEncoding(cert.getSignatureEncoding());
        }
        catch (PropertyVetoException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public final synchronized void sign(Object content, PrivateKey signingKey, Signature signingEngine) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, PersistenceServiceException, InvalidKeyException {
        if (signingKey == null) {
            throw new NullPointerException("signingKey");
        }
        if (signingEngine == null) {
            throw new NullPointerException("signingEngine");
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "locked", this.isLocked(), Boolean.TRUE);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(evt);
        }
        this.fireVetoableChange(evt);
        try {
            byte[] beo = PersistenceService.store2ByteArray(content);
            signingEngine.initSign(signingKey);
            signingEngine.update(beo);
            byte[] b64es = Base64.encodeBase64((byte[])signingEngine.sign());
            String signature = new String(b64es, 0, b64es.length, BASE64_CHARSET);
            this.setEncoded(new String(beo, "UTF-8"));
            this.setSignature(signature);
            this.setSignatureAlgorithm(signingEngine.getAlgorithm());
            this.setSignatureEncoding(SIGNATURE_ENCODING);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (SignatureException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        this.locked = true;
        this.firePropertyChange(evt);
    }

    public final synchronized void verify(PublicKey verificationKey, Signature verificationEngine) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, InvalidKeyException, SignatureException, GenericCertificateIntegrityException {
        if (verificationKey == null) {
            throw new NullPointerException("verificationKey");
        }
        if (verificationEngine == null) {
            throw new NullPointerException("verificationEngine");
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "locked", this.isLocked(), Boolean.TRUE);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(evt);
        }
        this.fireVetoableChange(evt);
        try {
            byte[] beo = this.getEncoded().getBytes("UTF-8");
            verificationEngine.initVerify(verificationKey);
            verificationEngine.update(beo);
            byte[] b64ds = Base64.decodeBase64((byte[])this.getSignature().getBytes(BASE64_CHARSET));
            if (!verificationEngine.verify(b64ds)) {
                throw new GenericCertificateIntegrityException();
            }
            this.setSignatureAlgorithm(verificationEngine.getAlgorithm());
            this.setSignatureEncoding(SIGNATURE_ENCODING);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        this.locked = true;
        this.firePropertyChange(evt);
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public Object getContent() throws GenericCertificateNotLockedException, PersistenceServiceException {
        if (!this.isLocked()) {
            throw new GenericCertificateNotLockedException();
        }
        return PersistenceService.load(this.getEncoded());
    }

    public final String getEncoded() {
        return this.encoded;
    }

    public synchronized void setEncoded(String encoded) throws GenericCertificateIsLockedException {
        if (encoded == null ? this.encoded == null : encoded.equals(this.encoded)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "encoded", this.getEncoded(), encoded);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(evt);
        }
        this.encoded = encoded;
        this.firePropertyChange(evt);
    }

    public final String getSignature() {
        return this.signature;
    }

    public synchronized void setSignature(String signature) throws GenericCertificateIsLockedException {
        if (signature == null ? this.signature == null : signature.equals(this.signature)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "signature", this.getSignature(), signature);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(evt);
        }
        this.signature = signature;
        this.firePropertyChange(evt);
    }

    public final String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public synchronized void setSignatureAlgorithm(String signatureAlgorithm) throws GenericCertificateIsLockedException {
        if (signatureAlgorithm == null ? this.signatureAlgorithm == null : signatureAlgorithm.equals(this.signatureAlgorithm)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "signatureAlgorithm", this.getSignatureAlgorithm(), signatureAlgorithm);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(evt);
        }
        this.signatureAlgorithm = signatureAlgorithm;
        this.firePropertyChange(evt);
    }

    public final String getSignatureEncoding() {
        return this.signatureEncoding;
    }

    public synchronized void setSignatureEncoding(String signatureEncoding) throws GenericCertificateIsLockedException {
        if (signatureEncoding == null ? this.signatureEncoding == null : signatureEncoding.equals(this.signatureEncoding)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "signatureEncoding", this.getSignatureEncoding(), signatureEncoding);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(evt);
        }
        this.signatureEncoding = signatureEncoding;
        this.firePropertyChange(evt);
    }

    public final synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public final void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    protected final void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(evt);
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(evt);
    }
}

