/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.Offset;
import com.sun.scenario.effect.impl.Renderer;
import java.util.HashMap;
import java.util.Map;

public class Identity
extends Effect {
    private Filterable src;
    private Point2D loc = new Point2D();
    private final Map<FilterContext, ImageData> datacache = new HashMap<FilterContext, ImageData>();

    public Identity(Filterable filterable) {
        this.src = filterable;
    }

    public final Filterable getSource() {
        return this.src;
    }

    public void setSource(Filterable filterable) {
        Filterable filterable2 = this.src;
        this.src = filterable;
        this.clearCache();
        this.firePropertyChange("source", filterable2, filterable);
    }

    public final Point2D getLocation() {
        return this.loc;
    }

    public void setLocation(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("Location must be non-null");
        }
        Point2D point2D2 = this.loc;
        this.loc.setLocation(point2D);
        this.firePropertyChange("location", point2D2, point2D);
    }

    public Bounds2D getBounds(BaseTransform baseTransform, Effect effect) {
        if (this.src == null) {
            return new Bounds2D();
        }
        int n = this.src.getPhysicalWidth();
        int n2 = this.src.getPhysicalHeight();
        Bounds2D bounds2D = new Bounds2D(this.loc.x, this.loc.y, this.loc.x + (float)n, this.loc.y + (float)n2);
        if (baseTransform != null && !baseTransform.isIdentity()) {
            bounds2D = Identity.transformBounds(baseTransform, bounds2D);
        }
        return bounds2D;
    }

    public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Effect effect) {
        ImageData imageData = this.datacache.get(filterContext);
        if (imageData == null) {
            Renderer renderer = Renderer.getRenderer(filterContext);
            Filterable filterable = this.src;
            if (filterable == null) {
                filterable = Identity.getCompatibleImage(filterContext, 1, 1);
                imageData = new ImageData(filterContext, filterable, new Rectangle(1, 1));
            } else {
                imageData = renderer.createImageData(filterContext, filterable);
            }
            if (imageData == null) {
                return new ImageData(filterContext, null, null);
            }
            this.datacache.put(filterContext, imageData);
        }
        imageData.addref();
        baseTransform = Offset.getOffsetTransform(baseTransform, this.loc.x, this.loc.y);
        imageData = this.ensureTransform(filterContext, imageData, baseTransform);
        return imageData;
    }

    public Effect.AccelType getAccelType(FilterContext filterContext) {
        return Effect.AccelType.INTRINSIC;
    }

    private void clearCache() {
        this.datacache.clear();
    }
}

