/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Rectangle;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.impl.Renderer;

public class ImageData {
    private ImageData sharedOwner;
    private FilterContext fctx;
    private int refcount;
    private Filterable image;
    private final Rectangle bounds;

    public ImageData(FilterContext filterContext, Filterable filterable, Rectangle rectangle) {
        this.fctx = filterContext;
        this.refcount = 1;
        this.image = filterable;
        this.bounds = rectangle;
    }

    public ImageData(ImageData imageData, Rectangle rectangle) {
        this(null, imageData.image, rectangle);
        this.sharedOwner = imageData;
        this.sharedOwner.addref();
    }

    public FilterContext getFilterContext() {
        return this.fctx;
    }

    public Filterable getImage() {
        return this.image;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getReferenceCount() {
        return this.refcount;
    }

    public void addref() {
        ++this.refcount;
    }

    public void unref() {
        if (--this.refcount == 0) {
            if (this.sharedOwner != null) {
                this.sharedOwner.unref();
                this.sharedOwner = null;
            } else if (this.fctx != null && this.image != null) {
                Effect.releaseCompatibleImage(this.fctx, this.image);
                this.fctx = null;
            }
            this.image = null;
        }
    }

    public boolean validate(FilterContext filterContext) {
        return this.image != null && Renderer.getRenderer(filterContext).isImageDataCompatible(this);
    }
}

