/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.BoxBlurState;

public class BoxShadowState
extends BoxBlurState {
    private Color4f shadowColor;
    private float spread;

    public Color4f getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color4f color4f) {
        if (color4f == null) {
            throw new IllegalArgumentException("Color must be non-null");
        }
        this.shadowColor = color4f;
    }

    public float getSpread() {
        return this.spread;
    }

    public void setSpread(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Spread must be in the range [0,1]");
        }
        this.spread = f;
    }

    public boolean isNop() {
        return false;
    }

    public boolean isNop(int n) {
        return n == 0 && super.isNop(n);
    }

    public boolean isShadow() {
        return true;
    }

    public float[] getShadowColorComponents(int n) {
        return n == 0 ? BLACK_COMPONENTS : this.shadowColor.getPremultipliedRGBComponents();
    }

    public EffectPeer getPeer(Renderer renderer, FilterContext filterContext, int n) {
        String string;
        int n2 = this.getScaledKernelSize(n);
        if (n == 0 && n2 <= 1) {
            return null;
        }
        int n3 = BoxShadowState.getPeerSize(n2);
        Effect.AccelType accelType = renderer.getAccelType();
        switch (accelType) {
            case NONE: 
            case SIMD: {
                if (this.spread == 0.0f) {
                    string = "BoxShadow";
                    break;
                }
            }
            default: {
                string = "LinearConvolveShadow";
            }
        }
        EffectPeer effectPeer = renderer.getPeerInstance(filterContext, string, n3);
        return effectPeer;
    }
}

