/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class TagListTableCellEditor
extends JPanel
implements TableCellEditor {
    private transient Object originalValue;
    private volatile boolean filterEvents;
    private JComboBox comboBox;
    private EventListenerList eventListenerList;
    private String[] tags;
    private static final String[] EMPTY_TAGS = new String[0];

    public TagListTableCellEditor() {
        this.setLayout(new BorderLayout());
        this.tags = EMPTY_TAGS;
        this.eventListenerList = new EventListenerList();
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(new SelectionAction());
        this.comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.comboBox.getInputMap().put(KeyStroke.getKeyStroke(27, 0), new CancelAction());
        this.comboBox.setEditable(true);
        this.comboBox.setRenderer(new TagListComboBoxRenderer());
        this.comboBox.setModel(new DefaultComboBoxModel<String>(this.getTags()));
        this.comboBox.setEditable(true);
        this.add((Component)this.comboBox, "Center");
        this.comboBox.requestFocus();
    }

    public String[] getTags() {
        return (String[])this.tags.clone();
    }

    public void setTags(String[] tags) {
        this.tags = (String[])tags.clone();
        this.comboBox.setModel(new DefaultComboBoxModel<String>(this.tags));
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    @Override
    public Object getCellEditorValue() {
        Object selectedItem = this.comboBox.getSelectedItem();
        if ("".equals(selectedItem)) {
            return null;
        }
        return selectedItem;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.comboBox.actionPerformed(new ActionEvent(this, 1001, this.comboBox.getActionCommand()));
            this.fireEditingStopped();
            return true;
        }
        catch (Exception e) {
            DebugLog.log((Object)"Error on Stop", (Throwable)e);
            this.fireEditingCanceled();
            return true;
        }
    }

    @Override
    public void cancelCellEditing() {
        try {
            this.filterEvents = true;
            this.comboBox.setSelectedItem(this.originalValue);
        }
        finally {
            this.filterEvents = false;
        }
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        try {
            this.filterEvents = true;
            this.comboBox.setSelectedItem(value);
        }
        finally {
            this.filterEvents = false;
        }
        this.originalValue = value;
        return this;
    }

    protected boolean isFilterEvents() {
        return this.filterEvents;
    }

    private static class TagListComboBoxRenderer
    extends DefaultListCellRenderer {
        private TagListComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent((JList<?>)list, "<undefined>", index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TagListTableCellEditor.this.cancelCellEditing();
        }
    }

    protected class SelectionAction
    implements ActionListener {
        protected SelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TagListTableCellEditor.this.isFilterEvents()) {
                return;
            }
            TagListTableCellEditor.this.stopCellEditing();
        }
    }

    protected static class NonFilteringPlainDocument
    implements Document {
        private PlainDocument backend = new PlainDocument();

        private NonFilteringPlainDocument() {
        }

        @Override
        public int getLength() {
            return this.backend.getLength();
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            this.backend.addDocumentListener(listener);
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            this.backend.removeDocumentListener(listener);
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            this.backend.addUndoableEditListener(listener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            this.backend.removeUndoableEditListener(listener);
        }

        @Override
        public Object getProperty(Object key) {
            return this.backend.getProperty(key);
        }

        @Override
        public void putProperty(Object key, Object value) {
            if ("filterNewlines".equals(key)) {
                return;
            }
            this.backend.putProperty(key, value);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            this.backend.remove(offs, len);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            this.backend.insertString(offset, str, a);
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return this.backend.getText(offset, length);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            this.backend.getText(offset, length, txt);
        }

        @Override
        public Position getStartPosition() {
            return this.backend.getStartPosition();
        }

        @Override
        public Position getEndPosition() {
            return this.backend.getEndPosition();
        }

        @Override
        public Position createPosition(int offs) throws BadLocationException {
            return this.backend.createPosition(offs);
        }

        @Override
        public Element[] getRootElements() {
            return this.backend.getRootElements();
        }

        @Override
        public Element getDefaultRootElement() {
            return this.backend.getDefaultRootElement();
        }

        @Override
        public void render(Runnable r) {
            this.backend.render(r);
        }
    }
}

