/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.table;

import javax.swing.event.TableModelEvent;
import org.pentaho.reporting.libraries.designtime.swing.table.GroupingHeader;
import org.pentaho.reporting.libraries.designtime.swing.table.GroupingModel;
import org.pentaho.reporting.libraries.designtime.swing.table.RowMapperTableModel;

public class GroupedTableModel
extends RowMapperTableModel {
    private GroupingModel parent;

    public GroupedTableModel(GroupingModel parent) {
        super(parent);
        this.parent = parent;
        this.recomputeRowCount();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int index = this.mapToModel(rowIndex);
        if (this.parent.isHeaderRow(index)) {
            return true;
        }
        return this.parent.isCellEditable(index, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int index = this.mapToModel(rowIndex);
        this.parent.setValueAt(aValue, index, columnIndex);
        if (this.parent.isHeaderRow(index)) {
            this.recomputeRowCount();
            this.fireTableModelEvent(new TableModelEvent(this));
        }
    }

    @Override
    protected boolean isFiltered(int row) {
        GroupingHeader groupHeader = this.parent.getGroupHeader(row);
        return groupHeader != null && groupHeader.isCollapsed() && !this.parent.isHeaderRow(row);
    }
}

