/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.DefineCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Right;
import org.h2.upgrade.v1_1.engine.RightOwner;
import org.h2.upgrade.v1_1.engine.Role;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.table.Table;
import org.h2.upgrade.v1_1.util.ObjectArray;

public class GrantRevoke
extends DefineCommand {
    public static final int GRANT = 0;
    public static final int REVOKE = 1;
    private ObjectArray<String> roleNames;
    private int operationType;
    private int rightMask;
    private ObjectArray<Table> tables = ObjectArray.newInstance();
    private RightOwner grantee;

    public GrantRevoke(Session session) {
        super(session);
    }

    public void setOperationType(int n) {
        this.operationType = n;
    }

    public void addRight(int n) {
        this.rightMask |= n;
    }

    public void addRoleName(String string) {
        if (this.roleNames == null) {
            this.roleNames = ObjectArray.newInstance();
        }
        this.roleNames.add(string);
    }

    public void setGranteeName(String string) throws SQLException {
        Database database = this.session.getDatabase();
        this.grantee = database.findUser(string);
        if (this.grantee == null) {
            this.grantee = database.findRole(string);
            if (this.grantee == null) {
                throw Message.getSQLException(90071, string);
            }
        }
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.roleNames != null) {
            for (String string : this.roleNames) {
                Role role = database.findRole(string);
                if (role == null) {
                    throw Message.getSQLException(90070, string);
                }
                if (this.operationType == 0) {
                    this.grantRole(role);
                    continue;
                }
                if (this.operationType == 1) {
                    this.revokeRole(role);
                    continue;
                }
                Message.throwInternalError("type=" + this.operationType);
            }
        } else if (this.operationType == 0) {
            this.grantRight();
        } else if (this.operationType == 1) {
            this.revokeRight();
        } else {
            Message.throwInternalError("type=" + this.operationType);
        }
        return 0;
    }

    private void grantRight() throws SQLException {
        Database database = this.session.getDatabase();
        for (Table table : this.tables) {
            Right right = this.grantee.getRightForTable(table);
            if (right == null) {
                int n = this.getObjectId(true, true);
                right = new Right(database, n, this.grantee, this.rightMask, table);
                this.grantee.grantRight(table, right);
                database.addDatabaseObject(this.session, right);
                continue;
            }
            right.setRightMask(right.getRightMask() | this.rightMask);
        }
    }

    private void grantRole(Role role) throws SQLException {
        Object object;
        if (role != this.grantee && this.grantee.isRoleGranted(role)) {
            return;
        }
        if (this.grantee instanceof Role && role.isRoleGranted((Role)(object = (Role)this.grantee))) {
            throw Message.getSQLException(90074, role.getSQL());
        }
        object = this.session.getDatabase();
        int n = this.getObjectId(true, true);
        Right right = new Right((Database)object, n, this.grantee, role);
        ((Database)object).addDatabaseObject(this.session, right);
        this.grantee.grantRole(role, right);
    }

    private void revokeRight() throws SQLException {
        for (Table table : this.tables) {
            Right right = this.grantee.getRightForTable(table);
            if (right == null) continue;
            int n = right.getRightMask();
            int n2 = n & ~this.rightMask;
            Database database = this.session.getDatabase();
            if (n2 == 0) {
                database.removeDatabaseObject(this.session, right);
                continue;
            }
            right.setRightMask(n2);
            database.update(this.session, right);
        }
    }

    private void revokeRole(Role role) throws SQLException {
        Right right = this.grantee.getRightForRole(role);
        if (right == null) {
            return;
        }
        Database database = this.session.getDatabase();
        database.removeDatabaseObject(this.session, right);
    }

    public boolean isTransactional() {
        return false;
    }

    public void addTable(Table table) {
        this.tables.add(table);
    }
}

