/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.engine;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.CommandInterface;
import org.h2.upgrade.v1_1.engine.SessionInterface;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.value.Value;

public abstract class SessionWithState
implements SessionInterface {
    protected ObjectArray<String> sessionState;
    protected boolean sessionStateChanged;
    private boolean sessionStateUpdating;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recreateSessionState() throws SQLException {
        if (this.sessionState != null && this.sessionState.size() > 0) {
            this.sessionStateUpdating = true;
            try {
                for (String string : this.sessionState) {
                    CommandInterface commandInterface = this.prepareCommand(string, Integer.MAX_VALUE);
                    commandInterface.executeUpdate();
                }
            }
            finally {
                this.sessionStateUpdating = false;
                this.sessionStateChanged = false;
            }
        }
    }

    public void readSessionState() throws SQLException {
        if (!this.sessionStateChanged || this.sessionStateUpdating) {
            return;
        }
        this.sessionStateChanged = false;
        this.sessionState = ObjectArray.newInstance();
        CommandInterface commandInterface = this.prepareCommand("SELECT * FROM INFORMATION_SCHEMA.SESSION_STATE", Integer.MAX_VALUE);
        ResultInterface resultInterface = commandInterface.executeQuery(0, false);
        while (resultInterface.next()) {
            Value[] valueArray = resultInterface.currentRow();
            this.sessionState.add(valueArray[1].getString());
        }
    }
}

