/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.expression;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.dml.Query;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Condition;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.ExpressionVisitor;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.table.ColumnResolver;
import org.h2.upgrade.v1_1.table.TableFilter;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueBoolean;

public class ConditionExists
extends Condition {
    private final Query query;

    public ConditionExists(Query query) {
        this.query = query;
    }

    public Value getValue(Session session) throws SQLException {
        this.query.setSession(session);
        ResultInterface resultInterface = this.query.query(1);
        session.addTemporaryResult(resultInterface);
        boolean bl = resultInterface.getRowCount() > 0;
        return ValueBoolean.get(bl);
    }

    public Expression optimize(Session session) throws SQLException {
        this.query.prepare();
        return this;
    }

    public String getSQL() {
        return "EXISTS(" + this.query.getPlanSQL() + ")";
    }

    public void updateAggregate(Session session) {
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        this.query.mapColumns(columnResolver, n + 1);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.query.setEvaluatable(tableFilter, bl);
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.query.isEverything(expressionVisitor);
    }

    public int getCost() {
        return 10 + (int)(10.0 * this.query.getCost());
    }
}

