/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.expression;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.dml.Select;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Comparison;
import org.h2.upgrade.v1_1.expression.Condition;
import org.h2.upgrade.v1_1.expression.ConditionAndOr;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.ExpressionColumn;
import org.h2.upgrade.v1_1.expression.ExpressionList;
import org.h2.upgrade.v1_1.expression.ExpressionVisitor;
import org.h2.upgrade.v1_1.expression.Function;
import org.h2.upgrade.v1_1.expression.TableFunction;
import org.h2.upgrade.v1_1.expression.ValueExpression;
import org.h2.upgrade.v1_1.index.Index;
import org.h2.upgrade.v1_1.index.IndexCondition;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.table.ColumnResolver;
import org.h2.upgrade.v1_1.table.FunctionTable;
import org.h2.upgrade.v1_1.table.TableFilter;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.util.StatementBuilder;
import org.h2.upgrade.v1_1.value.CompareMode;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueBoolean;
import org.h2.upgrade.v1_1.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionIn
extends Condition {
    private final Database database;
    private Expression left;
    private final ObjectArray<Expression> valueList;
    private Value min;
    private Value max;
    private int queryLevel;

    public ConditionIn(Database database, Expression expression, ObjectArray<Expression> objectArray) {
        this.database = database;
        this.left = expression;
        this.valueList = objectArray;
    }

    @Override
    public Value getValue(Session session) throws SQLException {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Expression expression : this.valueList) {
            Value value2 = expression.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                bl2 = true;
                continue;
            }
            bl = Comparison.compareNotNull(this.database, value, value2 = value2.convertTo(value.getType()), 0);
            if (!bl) continue;
            break;
        }
        if (!bl && bl2) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        this.left.mapColumns(columnResolver, n);
        for (Expression expression : this.valueList) {
            expression.mapColumns(columnResolver, n);
        }
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    @Override
    public Expression optimize(Session session) throws SQLException {
        Object object;
        int n;
        this.left = this.left.optimize(session);
        boolean bl = this.left.isConstant();
        if (bl && this.left == ValueExpression.getNull()) {
            return this.left;
        }
        boolean bl2 = true;
        for (n = 0; n < this.valueList.size(); ++n) {
            object = this.valueList.get(n);
            object = ((Expression)object).optimize(session);
            if (bl2 && !((Expression)object).isConstant()) {
                bl2 = false;
            }
            this.valueList.set(n, (Expression)object);
        }
        if (bl && bl2) {
            return ValueExpression.get(this.getValue(session));
        }
        if (this.valueList.size() == 1) {
            Expression expression = this.valueList.get(0);
            object = new Comparison(session, 0, this.left, expression);
            object = ((Expression)object).optimize(session);
            return object;
        }
        if (SysProperties.OPTIMIZE_IN && !SysProperties.OPTIMIZE_IN_LIST) {
            n = this.left.getType();
            object = ExpressionVisitor.get(0);
            ((ExpressionVisitor)object).setQueryLevel(this.queryLevel);
            if (this.areAllValues((ExpressionVisitor)object) && this.left instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)this.left).getColumn();
                boolean bl3 = column.isNullable();
                CompareMode compareMode = session.getDatabase().getCompareMode();
                for (int i = 0; i < this.valueList.size(); ++i) {
                    Expression expression = this.valueList.get(i);
                    Value value = expression.getValue(session);
                    value = value.convertTo(n);
                    this.valueList.set(i, ValueExpression.get(value));
                    if (!(this.min != null && this.min.compareTo(value, compareMode) <= 0 || value == ValueNull.INSTANCE && !bl3)) {
                        this.min = value;
                    }
                    if (this.max != null && this.max.compareTo(value, compareMode) >= 0) continue;
                    this.max = value;
                }
            }
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (SysProperties.OPTIMIZE_IN_LIST) {
            ExpressionVisitor expressionVisitor = ExpressionVisitor.get(6);
            expressionVisitor.setResolver(tableFilter);
            for (Expression expression : this.valueList) {
                if (expression.isEverything(expressionVisitor)) continue;
                return;
            }
            tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, this.valueList));
            return;
        }
        if (!SysProperties.OPTIMIZE_IN) {
            return;
        }
        if (this.min == null && this.max == null) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.get(1, expressionColumn, ValueExpression.get(this.min)));
        tableFilter.addIndexCondition(IndexCondition.get(3, expressionColumn, ValueExpression.get(this.max)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        for (Expression expression : this.valueList) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        statementBuilder.append(this.left.getSQL()).append(" IN(");
        for (Expression expression : this.valueList) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append("))").toString();
    }

    @Override
    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        for (Expression expression : this.valueList) {
            expression.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.left.isEverything(expressionVisitor)) {
            return false;
        }
        return this.areAllValues(expressionVisitor);
    }

    private boolean areAllValues(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.valueList) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = this.left.getCost();
        for (Expression expression : this.valueList) {
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public Expression optimizeInJoin(Session session, Select select) throws SQLException {
        Object object;
        if (SysProperties.OPTIMIZE_IN_LIST) {
            return this;
        }
        if (!this.areAllValues(ExpressionVisitor.get(3))) {
            return this;
        }
        if (!this.areAllValues(ExpressionVisitor.get(0))) {
            return this;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return this;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        Index index = expressionColumn.getTableFilter().getTable().getIndexForColumn(expressionColumn.getColumn(), false);
        if (index == null) {
            return this;
        }
        Database database = session.getDatabase();
        Schema schema = database.getSchema("PUBLIC");
        int n = this.valueList.size();
        TableFunction tableFunction = new TableFunction(this.database, Function.getFunctionInfo("TABLE_DISTINCT"), n);
        Expression[] expressionArray = new Expression[n];
        for (int i = 0; i < n; ++i) {
            object = this.valueList.get(i);
            expressionArray[i] = object;
        }
        ExpressionList expressionList = new ExpressionList(expressionArray);
        tableFunction.setParameter(0, expressionList);
        tableFunction.doneWithParameters();
        object = ObjectArray.newInstance();
        int n2 = this.left.getType();
        String string = session.getNextSystemIdentifier(select.getSQL());
        Column column = new Column(string, n2);
        ((ObjectArray)object).add(column);
        tableFunction.setColumns((ObjectArray<Column>)object);
        FunctionTable functionTable = new FunctionTable(schema, session, tableFunction, tableFunction);
        String string2 = session.getNextSystemIdentifier(select.getSQL());
        TableFilter tableFilter = new TableFilter(session, functionTable, string2, false, select);
        select.addTableFilter(tableFilter, true);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(database, null, string2, string);
        Expression expression = new Comparison(session, 0, this.left, expressionColumn2);
        ((Expression)expression).mapColumns(tableFilter, 0);
        expression = ((Expression)expression).optimize(session);
        return new ConditionAndOr(0, this, expression);
    }

    public Expression getAdditional(Session session, Comparison comparison) {
        Expression expression = comparison.getIfEquals(this.left);
        if (expression != null) {
            this.valueList.add(expression);
            return this;
        }
        return null;
    }
}

