/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.expression;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.dml.Query;
import org.h2.upgrade.v1_1.command.dml.Select;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Comparison;
import org.h2.upgrade.v1_1.expression.Condition;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.ExpressionColumn;
import org.h2.upgrade.v1_1.expression.ExpressionVisitor;
import org.h2.upgrade.v1_1.index.Index;
import org.h2.upgrade.v1_1.index.IndexCondition;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.table.ColumnResolver;
import org.h2.upgrade.v1_1.table.TableFilter;
import org.h2.upgrade.v1_1.table.TableView;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueBoolean;
import org.h2.upgrade.v1_1.value.ValueNull;

public class ConditionInSelect
extends Condition {
    private Database database;
    private Expression left;
    private Query query;
    private boolean all;
    private int compareType;
    private int queryLevel;

    public ConditionInSelect(Database database, Expression expression, Query query, boolean bl, int n) {
        this.database = database;
        this.left = expression;
        this.query = query;
        this.all = bl;
        this.compareType = n;
    }

    public Value getValue(Session session) throws SQLException {
        this.query.setSession(session);
        ResultInterface resultInterface = this.query.query(0);
        session.addTemporaryResult(resultInterface);
        boolean bl = false;
        boolean bl2 = this.all;
        Value value = this.left.getValue(session);
        boolean bl3 = false;
        while (resultInterface.next()) {
            boolean bl4;
            Value value2;
            if (!bl3) {
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                bl3 = true;
            }
            if ((value2 = resultInterface.currentRow()[0]) == ValueNull.INSTANCE) {
                bl4 = false;
                bl = true;
            } else {
                bl4 = Comparison.compareNotNull(this.database, value, value2, this.compareType);
            }
            if (!bl4 && this.all) {
                bl2 = false;
                break;
            }
            if (!bl4 || this.all) continue;
            bl2 = true;
            break;
        }
        if (!bl3) {
            return ValueBoolean.get(false);
        }
        if (!bl2 && bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl2);
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        this.left.mapColumns(columnResolver, n);
        this.query.mapColumns(columnResolver, n + 1);
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    public Expression optimize(Session session) throws SQLException {
        this.left = this.left.optimize(session);
        this.query.prepare();
        if (this.query.getColumnCount() != 1) {
            throw Message.getSQLException(90052);
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.query.setEvaluatable(tableFilter, bl);
    }

    public String getSQL() {
        return "(" + this.left.getSQL() + " IN(" + this.query.getPlanSQL() + "))";
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.query.isEverything(expressionVisitor);
    }

    public int getCost() {
        return this.left.getCost() + 10 + (int)(10.0 * this.query.getCost());
    }

    public Expression optimizeInJoin(Session session, Select select) throws SQLException {
        this.query.setDistinct(true);
        if (SysProperties.OPTIMIZE_IN_LIST) {
            return this;
        }
        if (this.all || this.compareType != 0) {
            return this;
        }
        if (!this.query.isEverything(3)) {
            return this;
        }
        if (!this.query.isEverything(0)) {
            return this;
        }
        String string = this.query.getFirstColumnAlias(session);
        if (string == null) {
            return this;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return this;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        Index index = expressionColumn.getTableFilter().getTable().getIndexForColumn(expressionColumn.getColumn(), false);
        if (index == null) {
            return this;
        }
        String string2 = session.getNextSystemIdentifier(select.getSQL());
        TableView tableView = TableView.createTempView(session, session.getUser(), string2, this.query, select);
        TableFilter tableFilter = new TableFilter(session, tableView, string2, false, select);
        select.addTableFilter(tableFilter, true);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(session.getDatabase(), null, tableView.getName(), string);
        Expression expression = new Comparison(session, 0, this.left, expressionColumn2);
        ((Expression)expression).mapColumns(tableFilter, 0);
        expression = ((Expression)expression).optimize(session);
        return expression;
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!SysProperties.OPTIMIZE_IN_LIST) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.get(6);
        expressionVisitor.setResolver(tableFilter);
        if (!this.query.isEverything(expressionVisitor)) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInQuery(expressionColumn, this.query));
    }
}

