/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.index;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.index.BtreeIndex;
import org.h2.upgrade.v1_1.index.BtreePage;
import org.h2.upgrade.v1_1.index.BtreePosition;
import org.h2.upgrade.v1_1.index.Cursor;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.Row;
import org.h2.upgrade.v1_1.result.SearchRow;

public class BtreeCursor
implements Cursor {
    private final Session session;
    private final BtreeIndex index;
    private final SearchRow last;
    private BtreePosition top;
    private SearchRow currentSearchRow;
    private Row currentRow;
    private boolean first;

    BtreeCursor(Session session, BtreeIndex btreeIndex, SearchRow searchRow) {
        this.session = session;
        this.index = btreeIndex;
        this.last = searchRow;
        this.first = true;
    }

    Session getSession() {
        return this.session;
    }

    void setStackPosition(int n) {
        this.top.position = n;
    }

    void push(BtreePage btreePage, int n) {
        if (SysProperties.CHECK && this.top != null && this.top.page == btreePage) {
            Message.throwInternalError();
        }
        this.top = new BtreePosition(btreePage, n, this.top);
    }

    BtreePosition pop() {
        BtreePosition btreePosition = this.top;
        if (btreePosition == null) {
            return null;
        }
        this.top = this.top.next;
        return btreePosition;
    }

    void setCurrentRow(SearchRow searchRow) {
        this.currentSearchRow = searchRow;
        this.currentRow = null;
    }

    public Row get() throws SQLException {
        if (this.currentRow == null && this.currentSearchRow != null) {
            this.currentRow = this.index.getRow(this.session, this.currentSearchRow.getKey());
        }
        return this.currentRow;
    }

    public SearchRow getSearchRow() {
        return this.currentSearchRow;
    }

    public long getKey() {
        return this.currentSearchRow.getKey();
    }

    public boolean next() throws SQLException {
        if (this.first) {
            this.first = false;
        } else {
            this.top.page.next(this, this.top.position);
        }
        if (this.currentSearchRow != null && this.last != null && this.index.compareRows(this.currentSearchRow, this.last) > 0) {
            this.currentSearchRow = null;
            this.currentRow = null;
        }
        return this.currentSearchRow != null;
    }

    public boolean previous() throws SQLException {
        if (this.currentSearchRow != null) {
            this.top.page.previous(this, this.top.position);
        }
        return this.currentSearchRow != null;
    }
}

