/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.jdbcx;

import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.transaction.xa.Xid;
import org.h2.upgrade.v1_1.jdbcx.JdbcDataSourceFactory;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.message.TraceObject;
import org.h2.upgrade.v1_1.util.ByteUtils;

public class JdbcXid
extends TraceObject
implements Xid {
    private static final String PREFIX = "XID";
    private int formatId;
    private byte[] branchQualifier;
    private byte[] globalTransactionId;

    JdbcXid(JdbcDataSourceFactory jdbcDataSourceFactory, int n, String string) throws SQLException {
        this.setTrace(jdbcDataSourceFactory.getTrace(), 14, n);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string2 = stringTokenizer.nextToken();
            if (!PREFIX.equals(string2)) {
                throw Message.getSQLException(90101, string);
            }
            this.formatId = Integer.parseInt(stringTokenizer.nextToken());
            this.branchQualifier = ByteUtils.convertStringToBytes(stringTokenizer.nextToken());
            this.globalTransactionId = ByteUtils.convertStringToBytes(stringTokenizer.nextToken());
        }
        catch (RuntimeException runtimeException) {
            throw Message.getSQLException(90101, string);
        }
    }

    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        stringBuilder.append('_').append(this.formatId).append('_').append(ByteUtils.convertBytesToString(this.branchQualifier)).append('_').append(ByteUtils.convertBytesToString(this.globalTransactionId));
        return stringBuilder.toString();
    }

    public int getFormatId() {
        this.debugCodeCall("getFormatId");
        return this.formatId;
    }

    public byte[] getBranchQualifier() {
        this.debugCodeCall("getBranchQualifier");
        return this.branchQualifier;
    }

    public byte[] getGlobalTransactionId() {
        this.debugCodeCall("getGlobalTransactionId");
        return this.globalTransactionId;
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.getAsString();
    }
}

