/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.result;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.ExpressionColumn;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.ResultDiskBuffer;
import org.h2.upgrade.v1_1.result.ResultExternal;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.result.ResultTempTable;
import org.h2.upgrade.v1_1.result.SortOrder;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.util.ValueHashMap;
import org.h2.upgrade.v1_1.value.DataType;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalResult
implements ResultInterface {
    private int maxMemoryRows;
    private Session session;
    private int visibleColumnCount;
    private Expression[] expressions;
    private int rowId;
    private int rowCount;
    private ObjectArray<Value[]> rows;
    private SortOrder sort;
    private ValueHashMap<Value[]> distinctRows;
    private Value[] currentRow;
    private int offset;
    private int limit;
    private ResultExternal disk;
    private int diskOffset;
    private boolean distinct;
    private boolean closed;

    public LocalResult() {
    }

    public LocalResult(Session session, Expression[] expressionArray, int n) {
        this.session = session;
        this.maxMemoryRows = session == null ? Integer.MAX_VALUE : session.getDatabase().getMaxMemoryRows();
        this.rows = ObjectArray.newInstance();
        this.visibleColumnCount = n;
        this.rowId = -1;
        this.expressions = expressionArray;
    }

    public LocalResult(Session session, ObjectArray<Expression> objectArray, int n) {
        this(session, LocalResult.getList(objectArray), n);
    }

    public static LocalResult read(Session session, ResultSet resultSet, int n) throws SQLException {
        ObjectArray<Expression> objectArray = LocalResult.getExpressionColumns(session, resultSet);
        int n2 = objectArray.size();
        LocalResult localResult = new LocalResult(session, objectArray, n2);
        for (int i = 0; (n == 0 || i < n) && resultSet.next(); ++i) {
            Value[] valueArray = new Value[n2];
            for (int j = 0; j < n2; ++j) {
                int n3 = localResult.getColumnType(j);
                valueArray[j] = DataType.readValue(session, resultSet, j + 1, n3);
            }
            localResult.addRow(valueArray);
        }
        localResult.done();
        return localResult;
    }

    private static ObjectArray<Expression> getExpressionColumns(Session session, ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        ObjectArray<Expression> objectArray = ObjectArray.newInstance(n);
        Database database = session == null ? null : session.getDatabase();
        for (int i = 0; i < n; ++i) {
            String string = resultSetMetaData.getColumnLabel(i + 1);
            int n2 = DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(i + 1));
            int n3 = resultSetMetaData.getPrecision(i + 1);
            int n4 = resultSetMetaData.getScale(i + 1);
            int n5 = resultSetMetaData.getColumnDisplaySize(i + 1);
            Column column = new Column(string, n2, n3, n4, n5);
            ExpressionColumn expressionColumn = new ExpressionColumn(database, column);
            objectArray.add(expressionColumn);
        }
        return objectArray;
    }

    public LocalResult createShallowCopy(Session session) {
        if (this.disk == null && (this.rows == null || this.rows.size() < this.rowCount)) {
            return null;
        }
        LocalResult localResult = new LocalResult();
        localResult.maxMemoryRows = this.maxMemoryRows;
        localResult.session = session;
        localResult.visibleColumnCount = this.visibleColumnCount;
        localResult.expressions = this.expressions;
        localResult.rowId = -1;
        localResult.rowCount = this.rowCount;
        localResult.rows = this.rows;
        localResult.sort = this.sort;
        localResult.distinctRows = this.distinctRows;
        localResult.distinct = this.distinct;
        localResult.currentRow = null;
        localResult.offset = 0;
        localResult.limit = 0;
        localResult.disk = this.disk;
        localResult.diskOffset = this.diskOffset;
        return localResult;
    }

    private static Expression[] getList(ObjectArray<Expression> objectArray) {
        Expression[] expressionArray = new Expression[objectArray.size()];
        objectArray.toArray((Expression[])expressionArray);
        return expressionArray;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sort = sortOrder;
    }

    public void setDistinct() {
        this.distinct = true;
        this.distinctRows = ValueHashMap.newInstance(this.session.getDatabase());
    }

    public void removeDistinct(Value[] valueArray) throws SQLException {
        if (!this.distinct) {
            Message.throwInternalError();
        }
        if (this.distinctRows != null) {
            ValueArray valueArray2 = ValueArray.get(valueArray);
            this.distinctRows.remove(valueArray2);
            this.rowCount = this.distinctRows.size();
        } else {
            this.rowCount = this.disk.removeRow(valueArray);
        }
    }

    public boolean containsDistinct(Value[] valueArray) throws SQLException {
        if (!this.distinct) {
            Message.throwInternalError();
        }
        if (this.distinctRows != null) {
            ValueArray valueArray2 = ValueArray.get(valueArray);
            return this.distinctRows.get(valueArray2) != null;
        }
        return this.disk.contains(valueArray);
    }

    @Override
    public void reset() throws SQLException {
        this.rowId = -1;
        if (this.disk != null) {
            this.disk.reset();
            if (this.diskOffset > 0) {
                for (int i = 0; i < this.diskOffset; ++i) {
                    this.disk.next();
                }
            }
        }
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.disk != null ? this.disk.next() : this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    public void addRow(Value[] valueArray) throws SQLException {
        if (this.distinct) {
            if (this.distinctRows != null) {
                ValueArray valueArray2 = ValueArray.get(valueArray);
                this.distinctRows.put(valueArray2, valueArray);
                this.rowCount = this.distinctRows.size();
                if (this.rowCount > SysProperties.MAX_MEMORY_ROWS_DISTINCT && this.session.getDatabase().isPersistent()) {
                    this.disk = new ResultTempTable(this.session, this.sort);
                    this.disk.addRows(this.distinctRows.values());
                    this.distinctRows = null;
                }
            } else {
                this.rowCount = this.disk.addRow(valueArray);
            }
            return;
        }
        this.rows.add(valueArray);
        ++this.rowCount;
        if (this.rows.size() > this.maxMemoryRows && this.session.getDatabase().isPersistent()) {
            if (this.disk == null) {
                this.disk = new ResultDiskBuffer(this.session, this.sort, valueArray.length);
            }
            this.addRowsToDisk();
        }
    }

    private void addRowsToDisk() throws SQLException {
        this.disk.addRows(this.rows);
        this.rows.clear();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void done() throws SQLException {
        if (this.distinct) {
            if (this.distinctRows != null) {
                this.rows = this.distinctRows.values();
                this.distinctRows = null;
            } else if (this.disk != null && this.sort != null) {
                Value[] valueArray;
                ResultExternal resultExternal = this.disk;
                this.disk = null;
                resultExternal.reset();
                this.rows = ObjectArray.newInstance();
                while ((valueArray = resultExternal.next()) != null) {
                    if (this.disk == null) {
                        this.disk = new ResultDiskBuffer(this.session, this.sort, valueArray.length);
                    }
                    this.rows.add(valueArray);
                    if (this.rows.size() <= this.maxMemoryRows) continue;
                    this.disk.addRows(this.rows);
                    this.rows.clear();
                }
                resultExternal.close();
            }
        }
        if (this.disk != null) {
            this.addRowsToDisk();
            this.disk.done();
        } else if (this.sort != null) {
            this.sort.sort(this.rows);
        }
        this.applyOffset();
        this.applyLimit();
        this.reset();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    private void applyLimit() {
        if (this.limit <= 0) {
            return;
        }
        if (this.disk == null) {
            if (this.rows.size() > this.limit) {
                this.rows.removeRange(this.limit, this.rows.size());
                this.rowCount = this.limit;
            }
        } else if (this.limit < this.rowCount) {
            this.rowCount = this.limit;
        }
    }

    @Override
    public boolean needToClose() {
        return this.disk != null;
    }

    @Override
    public void close() {
        if (this.disk != null) {
            this.disk.close();
            this.disk = null;
            this.closed = true;
        }
    }

    @Override
    public String getAlias(int n) {
        return this.expressions[n].getAlias();
    }

    @Override
    public String getTableName(int n) {
        return this.expressions[n].getTableName();
    }

    @Override
    public String getSchemaName(int n) {
        return this.expressions[n].getSchemaName();
    }

    @Override
    public int getDisplaySize(int n) {
        return this.expressions[n].getDisplaySize();
    }

    @Override
    public String getColumnName(int n) {
        return this.expressions[n].getColumnName();
    }

    @Override
    public int getColumnType(int n) {
        return this.expressions[n].getType();
    }

    @Override
    public long getColumnPrecision(int n) {
        return this.expressions[n].getPrecision();
    }

    @Override
    public int getNullable(int n) {
        return this.expressions[n].getNullable();
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return this.expressions[n].isAutoIncrement();
    }

    @Override
    public int getColumnScale(int n) {
        return this.expressions[n].getScale();
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    private void applyOffset() {
        if (this.offset <= 0) {
            return;
        }
        if (this.disk == null) {
            if (this.offset >= this.rows.size()) {
                this.rows.clear();
                this.rowCount = 0;
            } else {
                int n = Math.min(this.offset, this.rows.size());
                this.rows.removeRange(0, n);
                this.rowCount -= n;
            }
        } else if (this.offset >= this.rowCount) {
            this.rowCount = 0;
        } else {
            this.diskOffset = this.offset;
            this.rowCount -= this.offset;
        }
    }

    public String toString() {
        return "columns: " + this.visibleColumnCount + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public void setFetchSize(int n) {
    }
}

