/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.security;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.security.BlockCipher;
import org.h2.upgrade.v1_1.security.CipherFactory;
import org.h2.upgrade.v1_1.security.SHA256;
import org.h2.upgrade.v1_1.store.DataHandler;
import org.h2.upgrade.v1_1.store.FileStore;
import org.h2.upgrade.v1_1.util.RandomUtils;

public class SecureFileStore
extends FileStore {
    private byte[] key;
    private BlockCipher cipher;
    private BlockCipher cipherForInitVector;
    private byte[] buffer = new byte[4];
    private long pos;
    private byte[] bufferForInitVector;
    private int keyIterations;

    public SecureFileStore(DataHandler dataHandler, String string, String string2, String string3, byte[] byArray, int n) throws SQLException {
        super(dataHandler, string, string2);
        this.key = byArray;
        this.cipher = CipherFactory.getBlockCipher(string3);
        this.cipherForInitVector = CipherFactory.getBlockCipher(string3);
        this.keyIterations = n;
        this.bufferForInitVector = new byte[16];
    }

    protected byte[] generateSalt() {
        return RandomUtils.getSecureBytes(16);
    }

    protected void initKey(byte[] byArray) {
        SHA256 sHA256 = new SHA256();
        this.key = sHA256.getHashWithSalt(this.key, byArray);
        for (int i = 0; i < this.keyIterations; ++i) {
            this.key = sHA256.getHash(this.key, true);
        }
        this.cipher.setKey(this.key);
        this.key = sHA256.getHash(this.key, true);
        this.cipherForInitVector.setKey(this.key);
    }

    protected void writeDirect(byte[] byArray, int n, int n2) throws SQLException {
        super.write(byArray, n, n2);
        this.pos += (long)n2;
    }

    public void write(byte[] byArray, int n, int n2) throws SQLException {
        if (this.buffer.length < byArray.length) {
            this.buffer = new byte[n2];
        }
        System.arraycopy(byArray, n, this.buffer, 0, n2);
        this.xorInitVector(this.buffer, 0, n2, this.pos);
        this.cipher.encrypt(this.buffer, 0, n2);
        super.write(this.buffer, 0, n2);
        this.pos += (long)n2;
    }

    protected void readFullyDirect(byte[] byArray, int n, int n2) throws SQLException {
        super.readFully(byArray, n, n2);
        this.pos += (long)n2;
    }

    public void readFully(byte[] byArray, int n, int n2) throws SQLException {
        super.readFully(byArray, n, n2);
        this.cipher.decrypt(byArray, n, n2);
        this.xorInitVector(byArray, n, n2, this.pos);
        this.pos += (long)n2;
    }

    public void seek(long l) throws SQLException {
        this.pos = l;
        super.seek(l);
    }

    public void setLength(long l) throws SQLException {
        long l2 = this.pos;
        long l3 = this.length();
        if (l > l3) {
            int n;
            this.seek(l3);
            byte[] byArray = EMPTY;
            while ((n = (int)Math.min(l - l3, (long)EMPTY.length)) > 0) {
                this.write(byArray, 0, n);
                l3 += (long)n;
            }
            this.seek(l2);
        } else {
            super.setLength(l);
        }
    }

    private void xorInitVector(byte[] byArray, int n, int n2, long l) {
        byte[] byArray2 = this.bufferForInitVector;
        while (n2 > 0) {
            int n3;
            for (n3 = 0; n3 < 16; n3 += 8) {
                long l2 = l + (long)n3 >>> 3;
                byArray2[n3] = (byte)(l2 >> 56);
                byArray2[n3 + 1] = (byte)(l2 >> 48);
                byArray2[n3 + 2] = (byte)(l2 >> 40);
                byArray2[n3 + 3] = (byte)(l2 >> 32);
                byArray2[n3 + 4] = (byte)(l2 >> 24);
                byArray2[n3 + 5] = (byte)(l2 >> 16);
                byArray2[n3 + 6] = (byte)(l2 >> 8);
                byArray2[n3 + 7] = (byte)l2;
            }
            this.cipherForInitVector.encrypt(byArray2, 0, 16);
            for (n3 = 0; n3 < 16; ++n3) {
                int n4 = n + n3;
                byArray[n4] = (byte)(byArray[n4] ^ byArray2[n3]);
            }
            l += 16L;
            n += 16;
            n2 -= 16;
        }
    }

    public boolean isEncrypted() {
        return true;
    }
}

