/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.store.DataHandler;
import org.h2.upgrade.v1_1.store.DataPage;
import org.h2.upgrade.v1_1.store.FileStore;
import org.h2.upgrade.v1_1.tools.CompressTool;

public class FileStoreOutputStream
extends OutputStream {
    private FileStore store;
    private DataPage page;
    private String compressionAlgorithm;
    private CompressTool compress;
    private byte[] buffer = new byte[1];

    public FileStoreOutputStream(FileStore fileStore, DataHandler dataHandler, String string) {
        this.store = fileStore;
        if (string != null) {
            this.compress = CompressTool.getInstance();
            this.compressionAlgorithm = string;
        }
        this.page = DataPage.create(dataHandler, 16);
    }

    public void write(int n) throws IOException {
        this.buffer[0] = (byte)n;
        this.write(this.buffer);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            try {
                this.page.reset();
                if (this.compress != null) {
                    if (n != 0 || n2 != byArray.length) {
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, n, byArray2, 0, n2);
                        byArray = byArray2;
                        n = 0;
                    }
                    int n3 = n2;
                    byArray = this.compress.compress(byArray, this.compressionAlgorithm);
                    n2 = byArray.length;
                    this.page.writeInt(n2);
                    this.page.writeInt(n3);
                    this.page.write(byArray, n, n2);
                } else {
                    this.page.writeInt(n2);
                    this.page.write(byArray, n, n2);
                }
                this.page.fillAligned();
                this.store.write(this.page.getBytes(), 0, this.page.length());
            }
            catch (SQLException sQLException) {
                throw Message.convertToIOException(sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.store != null) {
            try {
                this.store.close();
            }
            finally {
                this.store = null;
            }
        }
    }
}

