/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.store;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.store.DataPage;
import org.h2.upgrade.v1_1.util.CacheObject;

public abstract class Record
extends CacheObject {
    private boolean deleted;
    private int sessionId;
    private int storageId;
    private int lastLog = -1;
    private int lastPos = -1;

    public abstract int getByteCount(DataPage var1) throws SQLException;

    public abstract void write(DataPage var1) throws SQLException;

    public void prepareWrite() throws SQLException {
    }

    public boolean isEmpty() {
        return false;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void commit() {
        this.sessionId = 0;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setStorageId(int n) {
        this.storageId = n;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public void setLastLog(int n, int n2) {
        this.lastLog = n;
        this.lastPos = n2;
    }

    public void setLogWritten(int n, int n2) {
        if (n < this.lastLog) {
            return;
        }
        if (n > this.lastLog || n2 >= this.lastPos) {
            this.lastLog = -1;
            this.lastPos = -1;
        }
    }

    public boolean canRemove() {
        if (this.isChanged() && !this.isLogWritten() || this.isPinned()) {
            return false;
        }
        return this.sessionId == 0;
    }

    public boolean isLogWritten() {
        return this.lastLog == -1;
    }
}

