/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.table;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.h2.upgrade.v1_1.command.ddl.CreateTableData;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.constraint.Constraint;
import org.h2.upgrade.v1_1.constraint.ConstraintReferential;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.DbObject;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.index.BtreeIndex;
import org.h2.upgrade.v1_1.index.Cursor;
import org.h2.upgrade.v1_1.index.HashIndex;
import org.h2.upgrade.v1_1.index.Index;
import org.h2.upgrade.v1_1.index.IndexType;
import org.h2.upgrade.v1_1.index.MultiVersionIndex;
import org.h2.upgrade.v1_1.index.NonUniqueHashIndex;
import org.h2.upgrade.v1_1.index.PageBtreeIndex;
import org.h2.upgrade.v1_1.index.PageDataIndex;
import org.h2.upgrade.v1_1.index.PageDelegateIndex;
import org.h2.upgrade.v1_1.index.RowIndex;
import org.h2.upgrade.v1_1.index.ScanIndex;
import org.h2.upgrade.v1_1.index.TreeIndex;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.message.Trace;
import org.h2.upgrade.v1_1.result.Row;
import org.h2.upgrade.v1_1.schema.SchemaObject;
import org.h2.upgrade.v1_1.store.DataPage;
import org.h2.upgrade.v1_1.store.Record;
import org.h2.upgrade.v1_1.store.RecordReader;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.table.IndexColumn;
import org.h2.upgrade.v1_1.table.Table;
import org.h2.upgrade.v1_1.util.MathUtils;
import org.h2.upgrade.v1_1.util.New;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.util.StatementBuilder;
import org.h2.upgrade.v1_1.util.StringUtils;
import org.h2.upgrade.v1_1.value.CompareMode;
import org.h2.upgrade.v1_1.value.DataType;
import org.h2.upgrade.v1_1.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableData
extends Table
implements RecordReader {
    private RowIndex scanIndex;
    private long rowCount;
    private volatile Session lockExclusive;
    private HashSet<Session> lockShared = New.hashSet();
    private Trace traceLock;
    private boolean globalTemporary;
    private final ObjectArray<Index> indexes = ObjectArray.newInstance();
    private long lastModificationId;
    private boolean containsLargeObject;
    private PageDataIndex mainIndex;
    private boolean waitForLock;

    public TableData(CreateTableData createTableData) throws SQLException {
        super(createTableData.schema, createTableData.id, createTableData.tableName, createTableData.persistIndexes, createTableData.persistData);
        Column[] columnArray = new Column[createTableData.columns.size()];
        createTableData.columns.toArray((Column[])columnArray);
        this.setColumns(columnArray);
        this.setTemporary(createTableData.temporary);
        if (this.database.isPageStoreEnabled() && createTableData.persistData && this.database.isPersistent()) {
            this.mainIndex = new PageDataIndex(this, createTableData.id, IndexColumn.wrap(columnArray), IndexType.createScan(createTableData.persistData), createTableData.headPos, createTableData.session);
            this.scanIndex = this.mainIndex;
        } else {
            this.scanIndex = new ScanIndex(this, createTableData.id, IndexColumn.wrap(columnArray), IndexType.createScan(createTableData.persistData));
        }
        this.indexes.add(this.scanIndex);
        for (Column column : columnArray) {
            if (!DataType.isLargeObject(column.getType())) continue;
            this.containsLargeObject = true;
            this.memoryPerRow = -1;
        }
        this.traceLock = this.database.getTrace("lock");
    }

    @Override
    public int getHeadPos() {
        return this.scanIndex.getHeadPos();
    }

    @Override
    public void close(Session session) throws SQLException {
        for (Index index : this.indexes) {
            index.close(session);
        }
    }

    public Row getRow(Session session, long l) throws SQLException {
        return this.scanIndex.getRow(session, l);
    }

    @Override
    public void addRow(Session session, Row row) throws SQLException {
        int n;
        this.lastModificationId = this.database.getNextModificationDataId();
        row.setSessionId(session.getId());
        try {
            for (n = 0; n < this.indexes.size(); ++n) {
                Index index = this.indexes.get(n);
                index.add(session, row);
                this.checkRowCount(session, index, 1);
            }
            ++this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (--n >= 0) {
                    Index index = this.indexes.get(n);
                    index.remove(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (SQLException sQLException) {
                this.trace.error("Could not undo operation", throwable);
                throw sQLException;
            }
            if (throwable instanceof Exception) {
                throw Message.convert((Exception)throwable);
            }
            throw Message.convertThrowable(throwable);
        }
    }

    private void checkRowCount(Session session, Index index, int n) {
        long l;
        if (SysProperties.CHECK && !this.database.isMultiVersion() && !(index instanceof PageDelegateIndex) && (l = index.getRowCount(session)) != this.rowCount + (long)n) {
            Message.throwInternalError("rowCount expected " + (this.rowCount + (long)n) + " got " + l + " " + this.getName() + "." + index.getName());
        }
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.indexes.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public ObjectArray<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        Object object;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw Message.getSQLException(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            if (this.database.isPageStoreEnabled()) {
                int n3 = this.database.isStarting() && this.database.getPageStore().getRootPageId(n) != 0 ? -1 : (!this.database.isStarting() && this.mainIndex.getRowCount(session) != 0L ? -1 : this.getMainIndexColumn(indexType, indexColumnArray));
                if (n3 != -1) {
                    this.mainIndex.setMainIndexColumn(n3);
                    object = new PageDelegateIndex(this, n, string, indexType, this.mainIndex, n2, session);
                } else {
                    object = new PageBtreeIndex(this, n, string, indexColumnArray, indexType, n2, session);
                }
            } else {
                object = new BtreeIndex(session, this, n, string, indexColumnArray, indexType, n2);
            }
        } else {
            object = indexType.isHash() ? (indexType.isUnique() ? new HashIndex(this, n, string, indexColumnArray, indexType) : new NonUniqueHashIndex(this, n, string, indexColumnArray, indexType)) : new TreeIndex(this, n, string, indexColumnArray, indexType);
        }
        if (this.database.isMultiVersion()) {
            object = new MultiVersionIndex((Index)object, this);
        }
        if (object.needRebuild() && this.rowCount > 0L) {
            try {
                long l;
                Index index = this.getScanIndex(session);
                long l2 = l = index.getRowCount(session);
                Cursor cursor = index.find(session, null, null);
                long l3 = 0L;
                int n4 = 10000;
                ObjectArray<Row> objectArray = ObjectArray.newInstance(n4);
                String string3 = this.getName() + ":" + object.getName();
                int n5 = MathUtils.convertLongToInt(l2);
                while (cursor.next()) {
                    this.database.setProgress(1, string3, MathUtils.convertLongToInt(l3++), n5);
                    Row row = cursor.get();
                    objectArray.add(row);
                    if (objectArray.size() >= n4) {
                        this.addRowsToIndex(session, objectArray, (Index)object);
                    }
                    --l;
                }
                this.addRowsToIndex(session, objectArray, (Index)object);
                if (SysProperties.CHECK && l != 0L) {
                    Message.throwInternalError("rowcount remaining=" + l + " " + this.getName());
                }
            }
            catch (SQLException sQLException) {
                this.getSchema().freeUniqueName(string);
                try {
                    object.remove(session);
                }
                catch (SQLException sQLException2) {
                    this.trace.error("Could not remove index", sQLException);
                    throw sQLException2;
                }
                throw sQLException;
            }
        }
        boolean bl = this.isTemporary();
        object.setTemporary(bl);
        if (object.getCreateSQL() != null) {
            object.setComment(string2);
            if (bl && !this.isGlobalTemporary()) {
                session.addLocalTempTableIndex((Index)object);
            } else {
                this.database.addSchemaObject(session, (SchemaObject)object);
            }
            if (!this.database.isPageStoreEnabled() && object.getIndexType().isPersistent() && !this.database.isReadOnly() && !this.database.getLog().containsInDoubtTransactions()) {
                this.database.update(session, (DbObject)object);
            }
        }
        this.indexes.add((Index)object);
        this.setModified();
        return object;
    }

    private int getMainIndexColumn(IndexType indexType, IndexColumn[] indexColumnArray) {
        if (this.mainIndex.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || indexColumnArray.length != 1) {
            return -1;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if (indexColumn.sortType != 0) {
            return -1;
        }
        switch (indexColumn.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return indexColumn.column.getColumnId();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    private void addRowsToIndex(Session session, ObjectArray<Row> objectArray, Index index) throws SQLException {
        final Index index2 = index;
        try {
            objectArray.sort(new Comparator<Row>(){

                @Override
                public int compare(Row row, Row row2) {
                    try {
                        return index2.compareRows(row, row2);
                    }
                    catch (SQLException sQLException) {
                        throw Message.convertToInternal(sQLException);
                    }
                }
            });
        }
        catch (Exception exception) {
            throw Message.convert(exception);
        }
        for (Row row : objectArray) {
            index.add(session, row);
        }
        objectArray.clear();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            return this.getScanIndex(session).getRowCount(session);
        }
        return this.rowCount;
    }

    @Override
    public void removeRow(Session session, Row row) throws SQLException {
        int n;
        if (this.database.isMultiVersion()) {
            if (row.isDeleted()) {
                throw Message.getSQLException(90131, this.getName());
            }
            n = row.getSessionId();
            int n2 = session.getId();
            if (n == 0) {
                row.setSessionId(n2);
            } else if (n != n2) {
                throw Message.getSQLException(90131, this.getName());
            }
        }
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            for (n = this.indexes.size() - 1; n >= 0; --n) {
                Index index = this.indexes.get(n);
                index.remove(session, row);
                this.checkRowCount(session, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (++n < this.indexes.size()) {
                    Index index = this.indexes.get(n);
                    index.add(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (SQLException sQLException) {
                this.trace.error("Could not undo operation", throwable);
                throw sQLException;
            }
            if (throwable instanceof Exception) {
                throw Message.convert((Exception)throwable);
            }
            throw Message.convertThrowable(throwable);
        }
    }

    @Override
    public void truncate(Session session) throws SQLException {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            long l;
            Index index = this.indexes.get(i);
            index.truncate(session);
            if (!SysProperties.CHECK || this.database.isPageStoreEnabled() || (l = index.getRowCount(session)) == 0L) continue;
            Message.throwInternalError("rowCount expected 0 got " + l);
        }
        this.rowCount = 0L;
    }

    @Override
    boolean isLockedExclusivelyBy(Session session) {
        return this.lockExclusive == session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Session session, boolean bl, boolean bl2) throws SQLException {
        int n = this.database.getLockMode();
        if (n == 0) {
            return;
        }
        if (!bl2 && this.database.isMultiVersion()) {
            if (bl) {
                bl = false;
            } else if (this.lockExclusive == null) {
                return;
            }
        }
        if (this.lockExclusive == session) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            try {
                this.doLock(session, n, bl);
            }
            finally {
                session.setWaitForLock(null);
            }
        }
    }

    private void doLock(Session session, int n, boolean bl) throws SQLException {
        this.traceLock(session, bl, "requesting for");
        long l = System.currentTimeMillis() + (long)session.getLockTimeout();
        boolean bl2 = false;
        while (this.lockExclusive != session) {
            long l2;
            if (bl) {
                if (this.lockExclusive == null) {
                    if (this.lockShared.isEmpty()) {
                        this.traceLock(session, bl, "added for");
                        session.addLock(this);
                        this.lockExclusive = session;
                        return;
                    }
                    if (this.lockShared.size() == 1 && this.lockShared.contains(session)) {
                        this.traceLock(session, bl, "add (upgraded) for ");
                        this.lockExclusive = session;
                        return;
                    }
                }
            } else if (this.lockExclusive == null) {
                if (n == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                    return;
                }
                if (!this.lockShared.contains(session)) {
                    this.traceLock(session, bl, "ok");
                    session.addLock(this);
                    this.lockShared.add(session);
                }
                return;
            }
            session.setWaitForLock(this);
            if (bl2) {
                ObjectArray<Session> objectArray = this.checkDeadlock(session, null, null);
                if (objectArray != null) {
                    throw Message.getSQLException(40001, this.getDeadlockDetails(objectArray));
                }
            } else {
                bl2 = true;
            }
            if ((l2 = System.currentTimeMillis()) >= l) {
                this.traceLock(session, bl, "timeout after " + session.getLockTimeout());
                throw Message.getSQLException(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, l - l2)) == 0L) {
                    l3 = 1L;
                }
                this.waitForLock = true;
                this.database.wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private String getDeadlockDetails(ObjectArray<Session> objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session : objectArray) {
            Table table = session.getWaitForLock();
            stringBuilder.append("\nSession ").append(session.toString()).append(" is waiting to lock ").append(table.toString()).append(" while locking ");
            int n = 0;
            for (Table table2 : session.getLocks()) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(table2.toString());
                if (!(table2 instanceof TableData)) continue;
                if (((TableData)table2).lockExclusive == session) {
                    stringBuilder.append(" (exclusive)");
                    continue;
                }
                stringBuilder.append(" (shared)");
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectArray<Session> checkDeadlock(Session session, Session session2, Set<Session> set) {
        Class<TableData> clazz = TableData.class;
        synchronized (TableData.class) {
            if (session2 == null) {
                session2 = session;
                set = New.hashSet();
            } else {
                if (session2 == session) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return ObjectArray.newInstance();
                }
                if (set.contains(session)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            set.add(session);
            ObjectArray<Session> objectArray = null;
            Object object = this.lockShared.iterator();
            while (object.hasNext()) {
                Table table;
                Session session3 = object.next();
                if (session3 == session || (table = session3.getWaitForLock()) == null || (objectArray = table.checkDeadlock(session3, session2, set)) == null) continue;
                objectArray.add(session);
                break;
            }
            if (objectArray == null && this.lockExclusive != null && (object = this.lockExclusive.getWaitForLock()) != null && (objectArray = ((Table)object).checkDeadlock(this.lockExclusive, session2, set)) != null) {
                objectArray.add(session);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return objectArray;
        }
    }

    private void traceLock(Session session, boolean bl, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug(session.getId() + " " + (bl ? "exclusive write lock" : "shared read lock") + " " + string + " " + this.getName());
        }
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("CREATE ");
        if (this.isTemporary()) {
            if (this.globalTemporary) {
                statementBuilder.append("GLOBAL ");
            } else {
                statementBuilder.append("LOCAL ");
            }
            statementBuilder.append("TEMPORARY ");
        } else if (this.isPersistIndexes()) {
            statementBuilder.append("CACHED ");
        } else {
            statementBuilder.append("MEMORY ");
        }
        statementBuilder.append("TABLE ").append(this.getSQL());
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        statementBuilder.append("(\n    ");
        for (Column column : this.columns) {
            statementBuilder.appendExceptFirst(",\n    ");
            statementBuilder.append(column.getCreateSQL());
        }
        statementBuilder.append("\n)");
        if (!(this.isTemporary() || this.isPersistIndexes() || this.isPersistData())) {
            statementBuilder.append("\nNOT PERSISTENT");
        }
        return statementBuilder.toString();
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusive != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session) {
        if (this.database != null) {
            this.traceLock(session, this.lockExclusive == session, "unlock");
            if (this.lockExclusive == session) {
                this.lockExclusive = null;
            }
            if (this.lockShared.size() > 0) {
                this.lockShared.remove(session);
            }
            Database database = this.database;
            synchronized (database) {
                if (this.database.getSessionCount() > 1 && this.waitForLock) {
                    this.database.notifyAll();
                }
            }
        }
    }

    @Override
    public Record read(Session session, DataPage dataPage) throws SQLException {
        return this.readRow(dataPage);
    }

    public Row readRow(DataPage dataPage) throws SQLException {
        int n = dataPage.readInt();
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            valueArray[i] = dataPage.readValue();
        }
        return this.createRow(valueArray);
    }

    public Row createRow(Value[] valueArray) {
        return new Row(valueArray, this.memoryPerRow);
    }

    public void setRowCount(long l) {
        this.rowCount = l;
    }

    @Override
    public void removeChildrenAndResources(Session session) throws SQLException {
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() == null) continue;
            this.database.removeSchemaObject(session, index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                Message.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.scanIndex = null;
        this.lockExclusive = null;
        this.lockShared = null;
        this.invalidate();
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
    }

    @Override
    public boolean canTruncate() {
        ObjectArray<Constraint> objectArray = this.getConstraints();
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            ConstraintReferential constraintReferential;
            Constraint constraint = objectArray.get(i);
            if (!constraint.getConstraintType().equals("REFERENTIAL") || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTableType() {
        return "TABLE";
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    @Override
    public boolean isGlobalTemporary() {
        return this.globalTemporary;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public long getRowCountApproximation() {
        return this.scanIndex.getRowCountApproximation();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

