/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import org.h2.upgrade.v1_1.message.Message;

public class ObjectUtils {
    private static final int MAX_JAVA_LOOP_COPY = 50;

    private ObjectUtils() {
    }

    public static byte[] serialize(Object object) throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw Message.getSQLException(90026, throwable, throwable.toString());
        }
    }

    public static Object deserialize(byte[] byArray) throws SQLException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (Throwable throwable) {
            throw Message.getSQLException(90027, throwable, throwable.toString());
        }
    }

    public static void arrayCopy(Object[] objectArray, Object[] objectArray2, int n) {
        if (n > 50) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        } else {
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = objectArray[i];
            }
        }
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }
}

