/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.util;

import java.lang.ref.SoftReference;
import org.h2.upgrade.v1_1.constant.SysProperties;

public class StringCache {
    private static final boolean ENABLED = true;
    private static SoftReference<String[]> softCache = new SoftReference<Object>(null);

    private StringCache() {
    }

    public static String get(String string) {
        if (!SysProperties.OBJECT_CACHE) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n = string.hashCode();
        String[] stringArray = StringCache.getCache();
        if (stringArray != null) {
            int n2 = n & SysProperties.OBJECT_CACHE_SIZE - 1;
            String string2 = stringArray[n2];
            if (string2 != null && string.equals(string2)) {
                return string2;
            }
            stringArray[n2] = string;
        }
        return string;
    }

    public static String getNew(String string) {
        if (!SysProperties.OBJECT_CACHE) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n = string.hashCode();
        String[] stringArray = StringCache.getCache();
        int n2 = n & SysProperties.OBJECT_CACHE_SIZE - 1;
        if (stringArray == null) {
            return string;
        }
        String string2 = stringArray[n2];
        if (string2 != null && string.equals(string2)) {
            return string2;
        }
        stringArray[n2] = string = new String(string);
        return string;
    }

    private static String[] getCache() {
        String[] stringArray;
        if (softCache != null && (stringArray = softCache.get()) != null) {
            return stringArray;
        }
        try {
            stringArray = new String[SysProperties.OBJECT_CACHE_SIZE];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
        softCache = new SoftReference<String[]>(stringArray);
        return stringArray;
    }

    public static void clearCache() {
        softCache = new SoftReference<Object>(null);
    }
}

