/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHCacheModule;

public class EHResourceFactoryCache
implements ResourceFactoryCache {
    private static final Log logger = LogFactory.getLog(EHResourceFactoryCache.class);
    private Cache factoryCache;

    public EHResourceFactoryCache(Cache factoryCache) {
        if (factoryCache == null) {
            throw new NullPointerException();
        }
        this.factoryCache = factoryCache;
    }

    @Override
    public Resource get(ResourceKey key, Class[] target) {
        for (int i = 0; i < target.length; ++i) {
            Resource res = this.getInternal(key, target[i]);
            if (res == null) continue;
            if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                EHCacheModule.CACHE_MONITOR.debug((Object)("Res  Cache Hit  " + key));
            }
            return res;
        }
        if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
            EHCacheModule.CACHE_MONITOR.debug((Object)("Res  Cache Miss  " + key));
        }
        return null;
    }

    private Resource getInternal(ResourceKey key, Class target) {
        try {
            Element element = this.factoryCache.get((Object)new CompoundCacheKey(key, target));
            if (element != null) {
                Resource resource = (Resource)element.getObjectValue();
                if (resource != null) {
                    return resource;
                }
                Resource resource1 = (Resource)element.getValue();
                if (resource1 != null) {
                    return resource1;
                }
                return null;
            }
            return null;
        }
        catch (CacheException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to retrieve resource for key " + key), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public void put(Resource resource) {
        block2: {
            CompoundCacheKey source = new CompoundCacheKey(resource.getSource(), resource.getTargetType());
            try {
                this.factoryCache.put(new Element((Object)source, (Object)resource));
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("Failed to store resource for key " + source), (Throwable)e);
            }
        }
    }

    @Override
    public void remove(Resource resource) {
        CompoundCacheKey source = new CompoundCacheKey(resource.getSource(), resource.getTargetType());
        this.factoryCache.remove((Object)source);
    }

    @Override
    public void clear() {
        try {
            this.factoryCache.removeAll();
        }
        catch (Exception e) {
            logger.debug((Object)"Clearing cache failed", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.factoryCache.getCacheManager().shutdown();
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to shut-down cache", (Throwable)e);
        }
    }

    private static class CompoundCacheKey {
        private ResourceKey key;
        private Class target;

        public CompoundCacheKey(ResourceKey key, Class target) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (target == null) {
                throw new NullPointerException();
            }
            this.key = key;
            this.target = target;
        }

        public ResourceKey getKey() {
            return this.key;
        }

        public Class getTarget() {
            return this.target;
        }

        public void setTarget(Class target) {
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundCacheKey that = (CompoundCacheKey)o;
            if (!this.target.equals(that.target)) {
                return false;
            }
            return this.key.equals(that.key);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CompoundCacheKey");
            sb.append("{key=").append(this.key);
            sb.append(", target=").append(this.target);
            sb.append('}');
            return sb.toString();
        }
    }
}

