/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.swing;

import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.LicenseManagementException;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.swing.UpdatingLicenseConsumerManager;
import net.java.truelicense.swing.util.Enabler;

@Immutable
final class DisablingLicenseConsumerManager
extends UpdatingLicenseConsumerManager {
    private static final long serialVersionUID = 0L;

    DisablingLicenseConsumerManager(Enabler enabler, LicenseConsumerManager licenseConsumerManager) {
        super(licenseConsumerManager, enabler);
    }

    @Override
    public License install(final Source source) throws LicenseManagementException {
        return this.run(new Action<License>(){

            @Override
            public License call() throws LicenseManagementException {
                return DisablingLicenseConsumerManager.this.manager.install(source);
            }
        });
    }

    @Override
    public void uninstall() throws LicenseManagementException {
        this.run(new Action<Void>(){

            @Override
            public Void call() throws LicenseManagementException {
                DisablingLicenseConsumerManager.this.manager.uninstall();
                return null;
            }
        });
    }

    private <T> T run(Action<T> action) throws LicenseManagementException {
        boolean bl = this.enabled();
        this.disable();
        try {
            return action.call();
        }
        catch (LicenseManagementException licenseManagementException) {
            this.enabled(bl);
            throw licenseManagementException;
        }
        catch (RuntimeException runtimeException) {
            this.enabled(bl);
            throw runtimeException;
        }
        catch (Error error) {
            this.enabled(bl);
            throw error;
        }
    }

    private static interface Action<T> {
        public T call() throws LicenseManagementException;
    }
}

