/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseValidationException;
import net.java.truelicense.obfuscate.ObfuscatedString;
import net.java.truelicense.swing.LicensePanel;
import net.java.truelicense.swing.LicenseWizard;
import net.java.truelicense.ui.LicenseWizardMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class DisplayPanel
extends LicensePanel {
    private static final long serialVersionUID = 1L;
    private License license;
    private JTextArea consumerComponent;
    private JTextArea holderComponent;
    private JTextArea infoComponent;
    private JTextArea issuedComponent;
    private JTextArea issuerComponent;
    private JTextArea notAfterComponent;
    private JTextArea notBeforeComponent;
    private JTextArea subjectComponent;
    static final /* synthetic */ boolean $assertionsDisabled;

    DisplayPanel(LicenseWizard licenseWizard) {
        super(licenseWizard);
        this.initComponents();
    }

    @Override
    public void onAfterStateSwitch() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isVisible()) {
            throw new AssertionError();
        }
        try {
            this.license = this.manager().view();
            this.onLicenseChange();
            this.manager().verify();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception instanceof LicenseValidationException ? exception.getLocalizedMessage() : this.format(LicenseWizardMessage.display_failure), this.format(LicenseWizardMessage.failure_title), 0);
        }
    }

    private void onLicenseChange() {
        if (null == this.license) {
            return;
        }
        this.subjectComponent.setText(DisplayPanel.nonNullOrEmptyString(this.license.getSubject()));
        this.holderComponent.setText(DisplayPanel.nonNullOrEmptyString(this.license.getHolder()));
        this.issuerComponent.setText(DisplayPanel.nonNullOrEmptyString(this.license.getIssuer()));
        this.issuedComponent.setText(this.format(this.license.getIssued()));
        this.notBeforeComponent.setText(this.format(this.license.getNotBefore()));
        this.notAfterComponent.setText(this.format(this.license.getNotAfter()));
        this.consumerComponent.setText(LicenseWizardMessage.display_consumerFormat.format(new Object[]{this.subject(), this.license.getConsumerType(), this.license.getConsumerAmount()}).toString());
        this.infoComponent.setText(DisplayPanel.nonNullOrEmptyString(this.license.getInfo()));
    }

    private static String nonNullOrEmptyString(@CheckForNull Object object) {
        return null != object ? object.toString() : DisplayPanel._string#0();
    }

    private String format(@CheckForNull Date date) {
        return LicenseWizardMessage.display_dateTimeFormat((String)this.subject(), (Date)date);
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.subjectComponent = new JTextArea();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.holderComponent = new JTextArea();
        JLabel jLabel3 = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.issuerComponent = new JTextArea();
        JLabel jLabel4 = new JLabel();
        this.issuedComponent = new JTextArea();
        JLabel jLabel5 = new JLabel();
        this.notBeforeComponent = new JTextArea();
        JLabel jLabel6 = new JLabel();
        this.notAfterComponent = new JTextArea();
        JLabel jLabel7 = new JLabel();
        this.consumerComponent = new JTextArea();
        JLabel jLabel8 = new JLabel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.infoComponent = new JTextArea();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.format(LicenseWizardMessage.display_title)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.setName(DisplayPanel.class.getSimpleName());
        this.setLayout(new GridBagLayout());
        jLabel.setLabelFor(this.subjectComponent);
        jLabel.setText(this.format(LicenseWizardMessage.display_subject));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 768;
        this.add((Component)jLabel, gridBagConstraints);
        this.subjectComponent.setEditable(false);
        this.subjectComponent.setFont(this.getFont());
        this.subjectComponent.setBorder(BorderFactory.createEtchedBorder());
        this.subjectComponent.setName(LicenseWizardMessage.display_subject.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.subjectComponent, gridBagConstraints);
        jLabel2.setLabelFor(this.holderComponent);
        jLabel2.setText(this.format(LicenseWizardMessage.display_holder));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 768;
        this.add((Component)jLabel2, gridBagConstraints);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(300, 65));
        this.holderComponent.setEditable(false);
        this.holderComponent.setFont(this.getFont());
        this.holderComponent.setLineWrap(true);
        this.holderComponent.setWrapStyleWord(true);
        this.holderComponent.setBorder(null);
        this.holderComponent.setName(LicenseWizardMessage.display_holder.name());
        jScrollPane.setViewportView(this.holderComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        jLabel3.setLabelFor(this.issuerComponent);
        jLabel3.setText(this.format(LicenseWizardMessage.display_issuer));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 768;
        this.add((Component)jLabel3, gridBagConstraints);
        jScrollPane2.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setPreferredSize(new Dimension(300, 65));
        this.issuerComponent.setEditable(false);
        this.issuerComponent.setFont(this.getFont());
        this.issuerComponent.setLineWrap(true);
        this.issuerComponent.setWrapStyleWord(true);
        this.issuerComponent.setBorder(null);
        this.issuerComponent.setName(LicenseWizardMessage.display_issuer.name());
        jScrollPane2.setViewportView(this.issuerComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane2, gridBagConstraints);
        jLabel4.setLabelFor(this.issuedComponent);
        jLabel4.setText(this.format(LicenseWizardMessage.display_issued));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 768;
        this.add((Component)jLabel4, gridBagConstraints);
        this.issuedComponent.setEditable(false);
        this.issuedComponent.setFont(this.getFont());
        this.issuedComponent.setBorder(BorderFactory.createEtchedBorder());
        this.issuedComponent.setName(LicenseWizardMessage.display_issued.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.issuedComponent, gridBagConstraints);
        jLabel5.setLabelFor(this.notBeforeComponent);
        jLabel5.setText(this.format(LicenseWizardMessage.display_notBefore));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 768;
        this.add((Component)jLabel5, gridBagConstraints);
        this.notBeforeComponent.setEditable(false);
        this.notBeforeComponent.setFont(this.getFont());
        this.notBeforeComponent.setBorder(BorderFactory.createEtchedBorder());
        this.notBeforeComponent.setName(LicenseWizardMessage.display_notBefore.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.notBeforeComponent, gridBagConstraints);
        jLabel6.setLabelFor(this.notAfterComponent);
        jLabel6.setText(this.format(LicenseWizardMessage.display_notAfter));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 768;
        this.add((Component)jLabel6, gridBagConstraints);
        this.notAfterComponent.setEditable(false);
        this.notAfterComponent.setFont(this.getFont());
        this.notAfterComponent.setBorder(BorderFactory.createEtchedBorder());
        this.notAfterComponent.setName(LicenseWizardMessage.display_notAfter.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.notAfterComponent, gridBagConstraints);
        jLabel7.setLabelFor(this.consumerComponent);
        jLabel7.setText(this.format(LicenseWizardMessage.display_consumer));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 768;
        this.add((Component)jLabel7, gridBagConstraints);
        this.consumerComponent.setEditable(false);
        this.consumerComponent.setFont(this.getFont());
        this.consumerComponent.setBorder(BorderFactory.createEtchedBorder());
        this.consumerComponent.setName(LicenseWizardMessage.display_consumer.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.consumerComponent, gridBagConstraints);
        jLabel8.setLabelFor(this.infoComponent);
        jLabel8.setText(this.format(LicenseWizardMessage.display_info));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 768;
        this.add((Component)jLabel8, gridBagConstraints);
        jScrollPane3.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setPreferredSize(new Dimension(300, 65));
        this.infoComponent.setEditable(false);
        this.infoComponent.setFont(this.getFont());
        this.infoComponent.setLineWrap(true);
        this.infoComponent.setWrapStyleWord(true);
        this.infoComponent.setBorder(null);
        this.infoComponent.setName(LicenseWizardMessage.display_info.name());
        jScrollPane3.setViewportView(this.infoComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane3, gridBagConstraints);
    }

    private static /* synthetic */ void _clinit@1506769953688#0() {
        DisplayPanel.$assertionsDisabled = !DisplayPanel.class.desiredAssertionStatus();
    }

    static {
        DisplayPanel._clinit@1506769953688#0();
    }

    private static /* synthetic */ String _string#0() {
        return new ObfuscatedString(new long[]{8744342746452363934L}).toString();
    }
}

