/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.swing.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.CheckForNull;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;
import net.java.truelicense.swing.util.ComponentEnabler;
import net.java.truelicense.swing.util.EnhancedButton;
import net.java.truelicense.swing.util.EnhancedDialog;
import net.java.truelicense.ui.wizard.BasicWizardController;
import net.java.truelicense.ui.wizard.WizardMessage;
import net.java.truelicense.ui.wizard.WizardView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class SwingWizardController<S extends Enum<S>, V extends Component>
extends BasicWizardController<S, V> {
    private final JDialog dialog;
    private final JButton cancelButton;
    private final JButton backButton;
    private final JButton nextButton;
    private final CardLayout cardLayout;
    private final JPanel cardPanel;
    private ReturnCode lastReturnCode = ReturnCode.cancel;

    protected SwingWizardController(@CheckForNull Dialog dialog) {
        this(new EnhancedDialog(dialog));
    }

    protected SwingWizardController(@CheckForNull Frame frame) {
        this(new EnhancedDialog(frame));
    }

    protected SwingWizardController(EnhancedDialog enhancedDialog) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WizardMessage wizardMessage = WizardMessage.valueOf((String)actionEvent.getActionCommand());
                if (WizardMessage.wizard_cancel.equals((Object)wizardMessage)) {
                    SwingWizardController.this.cancel();
                } else if (WizardMessage.wizard_back.equals((Object)wizardMessage)) {
                    SwingWizardController.this.switchBack();
                } else if (WizardMessage.wizard_next.equals((Object)wizardMessage)) {
                    SwingWizardController.this.switchNext();
                } else if (WizardMessage.wizard_finish.equals((Object)wizardMessage)) {
                    SwingWizardController.this.finish();
                } else {
                    throw new AssertionError();
                }
            }
        };
        this.cancelButton = new EnhancedButton();
        this.cancelButton.setName(WizardMessage.wizard_cancel.name());
        this.cancelButton.setActionCommand(WizardMessage.wizard_cancel.name());
        this.cancelButton.addActionListener(actionListener);
        this.backButton = new EnhancedButton();
        this.backButton.setName(WizardMessage.wizard_back.name());
        this.backButton.setActionCommand(WizardMessage.wizard_back.name());
        this.backButton.addActionListener(actionListener);
        this.nextButton = new EnhancedButton();
        this.nextButton.setName(WizardMessage.wizard_next.name());
        this.nextButton.setActionCommand(WizardMessage.wizard_next.name());
        this.nextButton.addActionListener(actionListener);
        EmptyBorder emptyBorder = new EmptyBorder(new Insets(10, 10, 10, 10));
        Box box = new Box(2);
        box.setBorder(emptyBorder);
        box.add(this.backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.nextButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(this.cancelButton);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JSeparator(), SwingWizardController._string#0());
        jPanel.add((Component)box, SwingWizardController._string#1());
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBorder(emptyBorder);
        this.dialog = (JDialog)Objects.requireNonNull((Object)enhancedDialog);
        enhancedDialog.setName(((Object)((Object)this)).getClass().getSimpleName());
        enhancedDialog.setLayout(new BorderLayout());
        enhancedDialog.add((Component)this.cardPanel, SwingWizardController._string#2());
        enhancedDialog.add((Component)jPanel, SwingWizardController._string#3());
        enhancedDialog.getRootPane().setDefaultButton(this.nextButton);
    }

    protected void view(S s, V v) {
        super.view(s, (WizardView)v);
        this.cardPanel.add((Component)v, ((Enum)s).name());
    }

    protected ComponentEnabler nextButtonProxy() {
        return new ComponentEnabler(){
            static final long serialVersionUID = 0L;
            static final /* synthetic */ boolean $assertionsDisabled;

            @Override
            protected JButton component() {
                return SwingWizardController.this.nextButton;
            }

            @Override
            public void enabled(boolean bl) {
                if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                    throw new AssertionError();
                }
                super.enabled(bl);
                SwingWizardController.this.requestFocusOnBackButtonIfEnabled();
                SwingWizardController.this.requestFocusOnNextButtonIfEnabled();
            }

            private static /* synthetic */ void _clinit@1506769953688#0() {
                2.$assertionsDisabled = !SwingWizardController.class.desiredAssertionStatus();
            }

            static {
                2._clinit@1506769953688#0();
            }
        };
    }

    public ReturnCode showModalDialog() {
        this.fireAfterStateSwitch();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
        return this.lastReturnCode;
    }

    public ReturnCode lastReturnCode() {
        return this.lastReturnCode;
    }

    protected void onAfterStateSwitch() {
        this.cancelButton.setText(this.format(WizardMessage.wizard_cancel));
        this.backButton.setText(this.format(WizardMessage.wizard_back));
        this.backButton.setEnabled(this.switchBackEnabled());
        this.requestFocusOnBackButtonIfEnabled();
        WizardMessage wizardMessage = this.switchNextEnabled() ? WizardMessage.wizard_next : WizardMessage.wizard_finish;
        this.nextButton.setActionCommand(wizardMessage.name());
        this.nextButton.setText(this.format(wizardMessage));
        this.nextButton.setEnabled(true);
        this.requestFocusOnNextButtonIfEnabled();
        this.cardLayout.show(this.cardPanel, ((Enum)this.currentState()).name());
    }

    private String format(WizardMessage wizardMessage) {
        return wizardMessage.format(new Object[0]).toString();
    }

    private void requestFocusOnBackButtonIfEnabled() {
        if (this.backButton.isEnabled()) {
            this.backButton.requestFocusInWindow();
        }
    }

    private void requestFocusOnNextButtonIfEnabled() {
        if (this.nextButton.isEnabled()) {
            this.nextButton.requestFocusInWindow();
        }
    }

    protected void cancel() {
        this.close(ReturnCode.cancel);
    }

    protected void finish() {
        this.close(ReturnCode.finish);
    }

    private void close(ReturnCode returnCode) {
        this.dialog.setVisible(false);
        this.lastReturnCode = returnCode;
    }

    private static /* synthetic */ String _string#0() {
        return new ObfuscatedString(new long[]{1619445768487272682L, 2384340704497134416L}).toString();
    }

    private static /* synthetic */ String _string#1() {
        return new ObfuscatedString(new long[]{7681956785770114338L, 3536667363619910758L}).toString();
    }

    private static /* synthetic */ String _string#2() {
        return new ObfuscatedString(new long[]{8874831446775558765L, 7818973331994272588L}).toString();
    }

    private static /* synthetic */ String _string#3() {
        return new ObfuscatedString(new long[]{-874214645204527515L, -2908294199145227685L}).toString();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ReturnCode
    extends Enum<ReturnCode> {
        public static final /* enum */ ReturnCode finish;
        public static final /* enum */ ReturnCode cancel;
        private static final /* synthetic */ ReturnCode[] $VALUES;

        public static ReturnCode[] values() {
            return (ReturnCode[])$VALUES.clone();
        }

        public static ReturnCode valueOf(String string) {
            return Enum.valueOf(ReturnCode.class, string);
        }

        private static /* synthetic */ void _clinit@1506769120408#0() {
            finish = new ReturnCode();
            cancel = new ReturnCode();
            $VALUES = new ReturnCode[]{finish, cancel};
        }

        static {
            ReturnCode._clinit@1506769120408#0();
        }

        private static /* synthetic */ String _string#0() {
            return new ObfuscatedString(new long[]{-6415348511790844683L, -7130597642938929076L}).toString();
        }

        private static /* synthetic */ String _string#1() {
            return new ObfuscatedString(new long[]{-6819788708006133346L, 3009793487918757936L}).toString();
        }
    }
}

