/*
 * Decompiled with CFR 0.152.
 */
package com.nexes.wizard;

import com.nexes.wizard.WizardController;
import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.swing.EnhancedButton;
import de.schlichtherle.swing.EnhancedDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard
implements PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    private static final ResourceBundle resources = ResourceBundle.getBundle("com/nexes/wizard/Resources");
    public static final String DEFAULT_BACK_BUTTON_TEXT = resources.getString("backButton");
    public static final String DEFAULT_NEXT_BUTTON_TEXT = resources.getString("nextButton");
    public static final String DEFAULT_FINISH_BUTTON_TEXT = resources.getString("finishButton");
    public static final String DEFAULT_CANCEL_BUTTON_TEXT = resources.getString("cancelButton");
    private WizardModel wizardModel;
    private WizardController wizardController;
    private EnhancedDialog wizardDialog;
    private int returnCode;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private EnhancedButton backButton;
    private EnhancedButton nextButton;
    private EnhancedButton cancelButton;

    public Wizard() {
        this(new WizardModel(), (Frame)null);
    }

    public Wizard(Dialog owner) {
        this(new WizardModel(), owner);
    }

    public Wizard(Frame owner) {
        this(new WizardModel(), owner);
    }

    public Wizard(WizardModel model, Dialog owner) {
        this.wizardDialog = new EnhancedDialog(owner);
        this.wizardModel = model;
        this.initComponents();
    }

    public Wizard(WizardModel model, Frame owner) {
        this.wizardDialog = new EnhancedDialog(owner);
        this.wizardModel = model;
        this.initComponents();
    }

    public JDialog getDialog() {
        return this.wizardDialog;
    }

    public Component getOwner() {
        return this.wizardDialog.getOwner();
    }

    public void setTitle(String s) {
        this.wizardDialog.setTitle(s);
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    public void setModal(boolean b) {
        this.wizardDialog.setModal(b);
    }

    public boolean isModal() {
        return this.wizardDialog.isModal();
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.setVisible(true);
        return this.returnCode;
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPanel(Object id, WizardPanelDescriptor panel) {
        this.cardPanel.add(panel.getPanelComponent(), id);
        panel.setWizard(this);
        this.wizardModel.registerPanel(id, panel);
        this.getDialog().pack();
    }

    public void setCurrentPanel(Object id) {
        WizardPanelDescriptor oldPanelDescriptor;
        if (id == null) {
            this.close(2);
        }
        if ((oldPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null) {
            oldPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(id);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.cardLayout.show(this.cardPanel, id.toString());
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (evt.getPropertyName().equals("nextButtonTextProperty")) {
            this.nextButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("backButtonTextProperty")) {
            this.backButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("cancelButtonTextProperty")) {
            this.cancelButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("nextButtonEnabledProperty")) {
            this.nextButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("backButtonEnabledProperty")) {
            this.backButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("cancelButtonEnabledProperty")) {
            this.cancelButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("nextButtonIconProperty")) {
            this.nextButton.setIcon((Icon)evt.getNewValue());
        } else if (evt.getPropertyName().equals("backButtonIconProperty")) {
            this.backButton.setIcon((Icon)evt.getNewValue());
        } else if (evt.getPropertyName().equals("cancelButtonIconProperty")) {
            this.cancelButton.setIcon((Icon)evt.getNewValue());
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    void close(int code) {
        this.returnCode = code;
        this.wizardDialog.setVisible(false);
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();
        Box buttonBox = new Box(2);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new EnhancedButton();
        this.nextButton = new EnhancedButton();
        this.cancelButton = new EnhancedButton();
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)separator, "North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(30));
        buttonBox.add(this.cancelButton);
        if (this.wizardModel.getBackButtonText() == null) {
            this.wizardModel.setBackButtonText(DEFAULT_BACK_BUTTON_TEXT);
        }
        if (this.wizardModel.getNextButtonText() == null) {
            this.wizardModel.setNextButtonText(DEFAULT_NEXT_BUTTON_TEXT);
        }
        if (this.wizardModel.getCancelButtonText() == null) {
            this.wizardModel.setCancelButtonText(DEFAULT_CANCEL_BUTTON_TEXT);
        }
        buttonPanel.add((Component)buttonBox, "East");
        this.wizardDialog.getContentPane().add((Component)buttonPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
        this.wizardDialog.setDefaultButton(this.nextButton);
    }
}

