/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class EnhancedDocument
extends PlainDocument {
    public static final String PROPERTY_EDITABLE = "editable";
    private static final long serialVersionUID = 1L;
    private boolean editable = true;
    protected PropertyChangeSupport changeSupport;

    public EnhancedDocument() {
    }

    public EnhancedDocument(AbstractDocument.Content c) {
        super(c);
    }

    public EnhancedDocument(String str) {
        EnhancedDocument.setText(this, str);
    }

    public synchronized boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean newEditable) {
        boolean oldEditable = this.isEditable();
        if (oldEditable == newEditable) {
            return;
        }
        this.editable = newEditable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldEditable, newEditable);
    }

    public synchronized String getText() {
        return EnhancedDocument.getText(this);
    }

    public synchronized void setText(String str) {
        EnhancedDocument.setText(this, str);
    }

    static String getText(Document doc) {
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    static void setText(Document doc, String str) {
        try {
            int docLen = doc.getLength();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).replace(0, docLen, str, null);
            } else {
                doc.remove(0, docLen);
                doc.insertString(0, str, null);
            }
        }
        catch (BadLocationException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public String toString() {
        return this.getText();
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

