/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.EnhancedComboBoxModel;
import de.schlichtherle.swing.EnhancedDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class EnhancedTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private final PropertyChangeListener listener = new Listener();

    public EnhancedTextField() {
    }

    public EnhancedTextField(String text) {
        super(text);
    }

    public EnhancedTextField(int columns) {
        super(columns);
    }

    public EnhancedTextField(String text, int columns) {
        super(text, columns);
    }

    public EnhancedTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    public void setEditable(boolean newEditable) {
        this.changeEditable(this.isEditable(), newEditable);
    }

    private void changeEditable(boolean oldEditable, boolean newEditable) {
        if (newEditable == oldEditable) {
            return;
        }
        super.setEditable(newEditable);
        Document model = super.getDocument();
        if (model instanceof EnhancedComboBoxModel) {
            ((EnhancedComboBoxModel)((Object)model)).setEditable(newEditable);
        }
    }

    protected Document createDefaultModel() {
        return new EnhancedDocument();
    }

    public void setDocument(Document newDocument) {
        Document oldDocument = this.getDocument();
        if (oldDocument instanceof EnhancedDocument) {
            ((EnhancedDocument)oldDocument).removePropertyChangeListener("editable", this.listener);
        }
        super.setDocument(newDocument);
        if (newDocument instanceof EnhancedDocument) {
            EnhancedDocument edoc = (EnhancedDocument)newDocument;
            edoc.addPropertyChangeListener("editable", this.listener);
            this.setEditable(edoc.isEditable());
        }
    }

    private final class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            EnhancedTextField.this.changeEditable(Boolean.TRUE.equals(evt.getOldValue()), Boolean.TRUE.equals(evt.getNewValue()));
        }
    }
}

