/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.MnemonicText;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class ResourceBundleAction
extends AbstractAction {
    private static final String[] actionKeys;
    private final Action delegate;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.schlichtherle.swing.ResourceBundleAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        actionKeys = Collections.list(new ActionKeyEnumeration()).toArray(new String[8]);
    }

    public ResourceBundleAction(Class clazz, String prefix) {
        this(clazz, prefix, null);
    }

    public ResourceBundleAction(Class clazz, String prefix, Action delegate) {
        this(clazz.getName(), ResourceBundleAction.getLoader(clazz), prefix, delegate);
    }

    public ResourceBundleAction(String baseName, String prefix) {
        this(baseName, Thread.currentThread().getContextClassLoader(), prefix, null);
    }

    public ResourceBundleAction(String baseName, ClassLoader classLoader, String prefix) {
        this(baseName, classLoader, prefix, null);
    }

    public ResourceBundleAction(String baseName, ClassLoader classLoader, String prefix, Action delegate) {
        this.delegate = delegate;
        this.loadResources(baseName, classLoader, prefix);
    }

    private static ClassLoader getLoader(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl != null) {
            return cl;
        }
        return ClassLoader.getSystemClassLoader();
    }

    private void loadResources(String baseName, ClassLoader classLoader, String prefix) {
        String nameValue;
        ResourceBundle resources = ResourceBundle.getBundle(baseName, Locale.getDefault(), classLoader);
        try {
            nameValue = resources.getString(prefix);
        }
        catch (MissingResourceException ignored) {
            nameValue = null;
        }
        Integer mnemonicValue = null;
        prefix = String.valueOf(prefix) + '.';
        int l = actionKeys.length;
        int i = 0;
        while (i < l) {
            String actionKey = actionKeys[i];
            String resourceKey = String.valueOf(prefix) + ResourceBundleAction.fixCase(actionKey);
            try {
                String resourceValue = resources.getString(resourceKey);
                if (!$assertionsDisabled && resourceValue == null) {
                    throw new AssertionError();
                }
                if ("Name".equals(actionKey)) {
                    nameValue = resourceValue;
                } else if ("SmallIcon".equals(actionKey)) {
                    resourceValue = resourceValue.charAt(0) == '/' ? resourceValue.substring(1) : "images/16x16/actions/" + resourceValue;
                    URL resource = classLoader.getResource(resourceValue);
                    this.putValue("SmallIcon", new ImageIcon(resource));
                } else if ("AcceleratorKey".equals(actionKey)) {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(resourceValue));
                } else if ("MnemonicKey".equals(actionKey)) {
                    try {
                        mnemonicValue = Integer.decode(resourceValue);
                    }
                    catch (NumberFormatException ex) {
                        mnemonicValue = new Integer(resourceValue.charAt(0));
                    }
                } else {
                    this.putValue(actionKey, resourceValue);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            ++i;
        }
        if (nameValue != null) {
            MnemonicText mt = new MnemonicText(nameValue);
            String text = mt.getText();
            this.putValue("Name", text);
            if (mnemonicValue == null && mt.getMnemonicIndex() >= 0) {
                mnemonicValue = new Integer(mt.getMnemonic());
            }
            if (mnemonicValue != null) {
                this.putValue("MnemonicKey", mnemonicValue);
            }
        }
    }

    private static final String fixCase(String s) {
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }

    public Object getValue(String key) {
        Object value = super.getValue(key);
        if (value != null) {
            return value;
        }
        if (this.delegate != null) {
            return this.delegate.getValue(key);
        }
        return null;
    }

    private static class ActionKeyEnumeration
    implements Enumeration {
        private final Field[] fields;
        private int i;
        private Object key;

        public ActionKeyEnumeration() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.swing.Action");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fields = clazz.getFields();
        }

        /*
         * Exception decompiling
         */
        public boolean hasMoreElements() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            try {
                Object object = this.key;
                return object;
            }
            finally {
                this.key = null;
            }
        }
    }
}

